/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.resource;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;

public class FontList {
    public static FontList instance = new FontList();
    private Map<String, Font> fonts = new HashMap<String, Font>();
    private boolean fontsLoaded = false;

    public void FontReload() {
        this.fonts.clear();
        this.fontsLoaded = false;
    }

    public void FlonList() {
        if (!this.fontsLoaded) {
            this.loadFont("ces-14x7", "font/ces-14x7.ttf");
            this.loadFont("testfont", "font/schindler-m-series-lop-nz-thin-1-beta.ttf");
            this.loadFont("acmeled", "font/acme-led.ttf");
            this.loadFont("koneModernization", "font/kone-modernization.ttf");
            this.loadFont("schindler_m_series", "font/schindler-m-line-led.ttf");
            this.loadFont("mitsubishi_modern", "font/mitsubishi_modern.ttf");
            this.loadFont("kone-m-series", "font/kone-m-series.ttf");
            this.loadFont("otis_series1", "font/series1.otf");
            this.loadFont("schindler_lcd", "font/schindler_lcd.ttf");
            this.loadFont("schindler_led", "font/schindler-led.ttf");
            this.loadFont("hitachi_b85", "font/hitachi_b85.ttf");
            this.loadFont("hitachi_modern", "font/hitachi_modern.ttf");
            this.fontsLoaded = true;
        }
    }

    private void loadFont(String fontName, String resourcePath) {
        ResourceManagerHelper.readResource((Identifier)new Identifier("yte", resourcePath), inputStream -> {
            try {
                Font font = Font.createFont(0, inputStream);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                ge.registerFont(font);
                this.fonts.put(fontName, font);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public Font getFont(String fontId) {
        Font font = this.fonts.get(fontId);
        if (font != null) {
            return font;
        }
        if (Objects.equals(fontId, "Arial")) {
            return new Font("Arial", 0, 12);
        }
        this.FlonList();
        font = this.fonts.get(fontId);
        if (font != null) {
            return font;
        }
        return new Font("Arial", 0, 12);
    }
}

