/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.RenderView;

public class ImageView
implements RenderView {
    private String id;
    private StoredMatrixTransformations storedMatrixTransformations;
    private float width;
    private float height;
    private float x;
    private float y;
    private float marginLeft;
    private float marginTop;
    private float marginRight;
    private float marginBottom;
    private Gravity gravity;
    private World world;
    private BlockPos blockPos;
    private Identifier texture;
    private float scale;
    private int light;
    private QueuedRenderLayer queuedRenderLayer = QueuedRenderLayer.EXTERIOR;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTexture(Identifier texture) {
        this.texture = texture;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.calculateDimensions();
    }

    public void setLight(int light) {
        this.light = light;
    }

    public void setLight(int light, QueuedRenderLayer queuedRenderLayer) {
        this.light = light;
        this.queuedRenderLayer = queuedRenderLayer;
    }

    public void setBasicsAttributes(World world, BlockPos blockPos) {
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public void render() {
        BlockState blockState = this.world.getBlockState(this.blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)DirectionHelper.FACING);
        StoredMatrixTransformations storedMatrixTransformations1 = this.storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, 0.43437499995343387));
        MainRenderer.scheduleRender((Identifier)this.texture, (boolean)false, (QueuedRenderLayer)this.queuedRenderLayer, (graphicsHolder, offset) -> {
            storedMatrixTransformations1.transform(graphicsHolder, offset);
            IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (Direction)facing, (int)-1, (int)this.light);
            graphicsHolder.pop();
        });
    }

    public void calculateDimensions() {
        this.height = this.width * this.scale;
    }

    @Override
    public void setStoredMatrixTransformations(StoredMatrixTransformations storedMatrixTransformations) {
        this.storedMatrixTransformations = storedMatrixTransformations;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    @Override
    public float[] getMargin() {
        return new float[]{this.marginLeft, this.marginTop, this.marginRight, this.marginBottom};
    }

    @Override
    public Gravity getGravity() {
        return this.gravity;
    }

    @Override
    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Override
    public void setMargin(float left, float top, float right, float bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setParentDimensions(float parentWidth, float parentHeight) {
    }

    @Override
    public void calculateLayoutWidth() {
    }

    @Override
    public void calculateLayoutHeight() {
    }

    @Override
    public float[] calculateChildGravityOffset(float childWidth, float childHeight, float[] childMargin, Gravity childGravity) {
        return new float[0];
    }

    @Override
    public Object getParentType() {
        return null;
    }

    @Override
    public void setParentType(Object thisObject) {
    }
}

