/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view;

import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.client.util.ClientGetLiftDetails;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.RenderView;

public class LiftArrowView
implements RenderView {
    private String id;
    private StoredMatrixTransformations storedMatrixTransformations;
    private float width;
    private float height;
    private float x;
    private float y;
    private float marginLeft;
    private float marginTop;
    private float marginRight;
    private float marginBottom;
    private Gravity gravity;
    private World world;
    private BlockPos blockPos;
    private Identifier texture;
    private Lift lift;
    private int upColor;
    private int downColor;
    private boolean needScroll;
    private float scrollSpeed;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void render() {
        boolean goingUp;
        float gameTick = InitClient.getGameTick();
        BlockState blockState = this.world.getBlockState(this.blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)DirectionHelper.FACING);
        StoredMatrixTransformations storedMatrixTransformations1 = this.storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, 0.43437499995343387));
        ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(this.world, this.lift, Init.positionToBlockPos((Position)this.lift.getCurrentFloor().getPosition()));
        LiftDirection liftDirection = (LiftDirection)liftDetails.left();
        boolean bl = goingUp = liftDirection == LiftDirection.UP;
        if (liftDirection != LiftDirection.NONE) {
            float uv = gameTick * this.scrollSpeed % 1.0f;
            int color = goingUp ? this.upColor : this.downColor;
            MainRenderer.scheduleRender((Identifier)this.texture, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations1.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)((float)(goingUp ? 1 : 0) + (this.needScroll ? uv : 0.0f)), (float)1.0f, (float)((float)(!goingUp ? 1 : 0) + (this.needScroll ? uv : 0.0f)), (Direction)Direction.UP, (int)color, (int)GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        }
    }

    @Override
    public void setStoredMatrixTransformations(StoredMatrixTransformations storedMatrixTransformations) {
        this.storedMatrixTransformations = storedMatrixTransformations;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float[] getMargin() {
        return new float[]{this.marginLeft, this.marginTop, this.marginRight, this.marginBottom};
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    @Override
    public Gravity getGravity() {
        return this.gravity;
    }

    @Override
    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Override
    public void setMargin(float left, float top, float right, float bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setParentDimensions(float parentWidth, float parentHeight) {
    }

    @Override
    public void calculateLayoutWidth() {
    }

    @Override
    public void calculateLayoutHeight() {
    }

    @Override
    public float[] calculateChildGravityOffset(float childWidth, float childHeight, float[] childMargin, Gravity childGravity) {
        return new float[0];
    }

    @Override
    public Object getParentType() {
        return null;
    }

    @Override
    public void setParentType(Object thisObject) {
    }

    public void setBasicsAttributes(World world, BlockPos blockPos, Lift lift) {
        this.world = world;
        this.blockPos = blockPos;
        this.lift = lift;
    }

    public void setColor(int color) {
        this.upColor = color;
        this.downColor = color;
    }

    public void setColor(int upColor, int downColor) {
        this.upColor = upColor;
        this.downColor = downColor;
    }

    public void setTexture(Identifier texture) {
        this.texture = texture;
    }

    public void setArrowScrolling(Boolean needScroll, float scrollSpeed) {
        this.needScroll = needScroll;
        this.scrollSpeed = scrollSpeed;
    }
}

