/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view;

import java.util.function.Consumer;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.HitResult;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.TestLiftButtons;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.RenderView;

public class LiftButtonView
implements RenderView {
    private boolean[] buttonStates = new boolean[]{false, false};
    private Identifier upButtonTexture;
    private Identifier downButtonTexture;
    private int defaultUpColor;
    private int defaultDownColor;
    private int hoverUpColor;
    private int hoverDownColor;
    private int pressedUpColor;
    private int pressedDownColor;
    private BlockPos blockPos;
    private Direction facing;
    private BlockState blockState;
    private World world;
    private StoredMatrixTransformations storedMatrixTransformations;
    private StoredMatrixTransformations storedMatrixTransformations1;
    private LiftButtonsBase.LiftButtonDescriptor buttonDescriptor;
    private int light;
    private float width;
    private float height;
    private float x;
    private float xLeft;
    private float xRight;
    private float y;
    private float yUp;
    private float yDown;
    private float marginLeft;
    private float marginTop;
    private float marginRight;
    private float marginBottom;
    private float spacing;
    private String id = "button";
    private Gravity gravity;
    private boolean canHover;
    private boolean lookingAtTopHalf;
    private boolean lookingAtBottomHalf;
    private boolean reverse;
    private boolean repeatButton;
    private boolean verticalAlignment;
    private boolean isLantern;
    private boolean lockPosition;
    private double clientMedian = 0.25;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void render() {
        this.blockState = this.world.getBlockState(this.blockPos);
        this.facing = IBlock.getStatePropertySafe((BlockState)this.blockState, (DirectionProperty)DirectionHelper.FACING);
        this.storedMatrixTransformations1 = this.storedMatrixTransformations.copy();
        this.storedMatrixTransformations1.add(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, 0.43437499995343387));
        this.dynamicRender();
    }

    private void dynamicRender() {
        HitResult hitResult = MinecraftClient.getInstance().getCrosshairTargetMapped();
        this.positionOffset(this.x, this.y, this.spacing);
        if (hitResult == null || !IBlock.getStatePropertySafe((BlockState)this.blockState, (BooleanProperty)TestLiftButtons.UNLOCKED)) {
            this.lookingAtBottomHalf = false;
            this.lookingAtTopHalf = false;
        } else {
            Vector3d hitLocation = hitResult.getPos();
            double hitY = MathHelper.fractionalPart((double)hitLocation.getYMapped());
            boolean inBlock = hitY < 0.5 && Init.newBlockPos((double)hitLocation.getXMapped(), (double)hitLocation.getYMapped(), (double)hitLocation.getZMapped()).equals((Object)this.blockPos);
            this.lookingAtTopHalf = inBlock && (!this.buttonDescriptor.hasDownButton() || hitY > this.clientMedian);
            boolean bl = this.lookingAtBottomHalf = inBlock && (!this.buttonDescriptor.hasUpButton() || hitY < this.clientMedian);
        }
        if (this.buttonDescriptor.hasDownButton()) {
            MainRenderer.scheduleRender((Identifier)this.downButtonTexture, (boolean)false, (QueuedRenderLayer)this.queuedRenderLayerRegulator(this.lookingAtBottomHalf, this.buttonStates[0]), (graphicsHolder, offset) -> {
                this.storedMatrixTransformations1.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.xLeft, (float)this.yDown, (float)this.width, (float)this.height, (float)1.0f, (float)(this.reverse ? 0.0f : 1.0f), (float)0.0f, (float)(this.reverse ? 1.0f : 0.0f), (Direction)this.facing, (int)(this.buttonStates[0] ? this.pressedDownColor : (this.lookingAtBottomHalf ? this.hoverDownColor : this.defaultDownColor)), (int)this.light);
                graphicsHolder.pop();
            });
        }
        if (this.buttonDescriptor.hasDownButton() && !this.buttonDescriptor.hasUpButton() && this.repeatButton) {
            MainRenderer.scheduleRender((Identifier)this.downButtonTexture, (boolean)false, (QueuedRenderLayer)this.queuedRenderLayerRegulator(this.lookingAtBottomHalf, this.buttonStates[0]), (graphicsHolder, offset) -> {
                this.storedMatrixTransformations1.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.xRight, (float)this.yUp, (float)this.width, (float)this.height, (float)1.0f, (float)(this.reverse ? 0.0f : 1.0f), (float)0.0f, (float)(this.reverse ? 1.0f : 0.0f), (Direction)this.facing, (int)(this.buttonStates[0] ? this.pressedDownColor : (this.lookingAtBottomHalf ? this.hoverDownColor : this.defaultDownColor)), (int)this.light);
                graphicsHolder.pop();
            });
        }
        if (this.buttonDescriptor.hasUpButton()) {
            MainRenderer.scheduleRender((Identifier)this.upButtonTexture, (boolean)false, (QueuedRenderLayer)this.queuedRenderLayerRegulator(this.lookingAtTopHalf, this.buttonStates[1]), (graphicsHolder, offset) -> {
                this.storedMatrixTransformations1.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.xRight, (float)this.yUp, (float)this.width, (float)this.height, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (Direction)this.facing, (int)(this.buttonStates[1] ? this.pressedUpColor : (this.lookingAtTopHalf ? this.hoverUpColor : this.defaultUpColor)), (int)this.light);
                graphicsHolder.pop();
            });
        }
        if (this.buttonDescriptor.hasUpButton() && !this.buttonDescriptor.hasDownButton() && this.repeatButton) {
            MainRenderer.scheduleRender((Identifier)this.upButtonTexture, (boolean)false, (QueuedRenderLayer)this.queuedRenderLayerRegulator(this.lookingAtTopHalf, this.buttonStates[1]), (graphicsHolder, offset) -> {
                this.storedMatrixTransformations1.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.xLeft, (float)this.yDown, (float)this.width, (float)this.height, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (Direction)this.facing, (int)(this.buttonStates[1] ? this.pressedUpColor : (this.lookingAtTopHalf ? this.hoverUpColor : this.defaultUpColor)), (int)this.light);
                graphicsHolder.pop();
            });
        }
    }

    private QueuedRenderLayer queuedRenderLayerRegulator(Boolean looking, Boolean buttonState) {
        return (looking != false || buttonState != false) & this.canHover || this.isLantern && buttonState != false ? QueuedRenderLayer.LIGHT_TRANSLUCENT : QueuedRenderLayer.EXTERIOR;
    }

    private void positionOffset(float x, float y, float spacing) {
        if (this.verticalAlignment) {
            this.yUp = this.buttonDescriptor.hasDownButton() || this.repeatButton || this.lockPosition ? y + this.height + spacing : y;
            this.yDown = y;
            this.xLeft = x;
            this.xRight = x;
        } else {
            this.xLeft = this.buttonDescriptor.hasDownButton() || this.repeatButton || this.lockPosition ? x + spacing + this.width : x;
            this.xRight = x;
            this.yUp = y;
            this.yDown = y;
        }
    }

    @Override
    public void setStoredMatrixTransformations(StoredMatrixTransformations storedMatrixTransformations) {
        this.storedMatrixTransformations = storedMatrixTransformations;
    }

    @Override
    public float[] getMargin() {
        return new float[]{this.marginLeft, this.marginTop, this.marginRight, this.marginBottom};
    }

    @Override
    public Gravity getGravity() {
        return this.gravity;
    }

    @Override
    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Override
    public float getWidth() {
        return !this.verticalAlignment && (this.buttonDescriptor.hasUpButton() && this.buttonDescriptor.hasDownButton() || this.repeatButton || this.lockPosition) ? this.width * 2.0f + this.spacing : this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float getHeight() {
        return this.verticalAlignment && (this.buttonDescriptor.hasUpButton() && this.buttonDescriptor.hasDownButton() || this.repeatButton || this.lockPosition) ? this.height * 2.0f + this.spacing : this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    @Override
    public void setMargin(float left, float top, float right, float bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setParentDimensions(float parentWidth, float parentHeight) {
    }

    @Override
    public void calculateLayoutWidth() {
    }

    @Override
    public void calculateLayoutHeight() {
    }

    @Override
    public float[] calculateChildGravityOffset(float childWidth, float childHeight, float[] childMargin, Gravity childGravity) {
        return new float[0];
    }

    @Override
    public Object getParentType() {
        return null;
    }

    @Override
    public void setParentType(Object thisObject) {
    }

    public void setBasicsAttributes(World world, BlockPos blockPos, LiftButtonsBase.LiftButtonDescriptor descriptor, boolean verticalAlignment, boolean repeatButton, boolean isLantern, boolean lockPosition) {
        this.world = world;
        this.blockPos = blockPos;
        this.buttonDescriptor = descriptor;
        this.verticalAlignment = verticalAlignment;
        this.repeatButton = repeatButton;
        this.isLantern = isLantern;
        this.lockPosition = lockPosition;
    }

    public void setLight(int light) {
        this.light = light;
    }

    public void setDownButtonLight() {
        this.buttonStates[0] = true;
    }

    public void setUpButtonLight() {
        this.buttonStates[1] = true;
    }

    public void setDefaultColor(int defaultColor) {
        this.defaultUpColor = defaultColor;
        this.defaultDownColor = defaultColor;
    }

    public void setDefaultColor(int defaultUpColor, int defaultDownColor) {
        this.defaultUpColor = defaultUpColor;
        this.defaultDownColor = defaultDownColor;
    }

    public void setHoverColor(int hoverColor) {
        this.hoverUpColor = hoverColor;
        this.hoverDownColor = hoverColor;
    }

    public void setHoverColor(int hoverUpColor, int hoverDownColor) {
        this.hoverUpColor = hoverUpColor;
        this.hoverDownColor = hoverDownColor;
    }

    public void setPressedColor(int pressedColor) {
        this.pressedUpColor = pressedColor;
        this.pressedDownColor = pressedColor;
    }

    public void setPressedColor(int pressedUpColor, int pressedDownColor) {
        this.pressedUpColor = pressedUpColor;
        this.pressedDownColor = pressedDownColor;
    }

    public void setTexture(Identifier texture, boolean reverse) {
        this.upButtonTexture = texture;
        this.downButtonTexture = texture;
        this.reverse = reverse;
    }

    public void setTexture(Identifier upButtonTexture, Identifier downButtonTexture, boolean reverse) {
        this.upButtonTexture = upButtonTexture;
        this.downButtonTexture = downButtonTexture;
        this.reverse = reverse;
    }

    public void setClientMedian(double clientMedian) {
        this.clientMedian = clientMedian;
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
    }

    public void setHover(Boolean hover) {
        this.canHover = hover;
    }

    public void addStoredMatrixTransformations(Consumer<GraphicsHolder> transformation) {
        this.storedMatrixTransformations1.add(transformation);
    }
}

