/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view;

import java.awt.Font;
import java.util.function.Consumer;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.client.TextureCache;
import top.xfunny.mod.client.resource.TextureList;
import top.xfunny.mod.client.util.ClientGetLiftDetails;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.RenderView;

public class LiftFloorDisplayView
implements RenderView {
    private String id;
    private StoredMatrixTransformations storedMatrixTransformations;
    private StoredMatrixTransformations storedMatrixTransformations1;
    private Font font;
    private int color;
    private int letterSpacing = 0;
    private World world;
    private BlockPos blockPos;
    private Lift lift;
    private float height;
    private float width;
    private boolean needScroll;
    private int textSize;
    private float scrollSpeed;
    private float x;
    private float y;
    private float textX;
    private String textureId;
    private int fontSize;
    private boolean noFloorNumber;
    private boolean noFloorDisplay;
    private float gameTick;
    private String text;
    private TextureCache.DynamicResource texture;
    private float fixedWidth;
    private float textWidth;
    private float textHeight;
    private float marginLeft;
    private float marginTop;
    private float marginRight;
    private float marginBottom;
    private Direction facing;
    private TextAlign textAlign = TextAlign.RIGHT;
    private Gravity gravity;
    private Consumer<GraphicsHolder> transformation;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void render() {
        this.calculateSize();
        this.calculateTextPositionX();
        BlockState blockState = this.world.getBlockState(this.blockPos);
        this.facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)DirectionHelper.FACING);
        this.storedMatrixTransformations1 = this.storedMatrixTransformations.copy();
        this.storedMatrixTransformations1.add(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, 0.43437499995343387));
        if (this.transformation != null) {
            this.storedMatrixTransformations1.add(this.transformation);
        }
        if (!this.noFloorNumber || !this.noFloorDisplay) {
            if (this.text.length() > this.textSize && this.needScroll) {
                float offset1 = this.gameTick * this.scrollSpeed % 1.0f;
                MainRenderer.scheduleRender((Identifier)this.texture.identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                    this.storedMatrixTransformations1.transform(graphicsHolder, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.textX, (float)this.y, (float)this.fixedWidth, (float)this.textHeight, (float)(offset1 + this.fixedWidth / this.textWidth), (float)1.0f, (float)offset1, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)GraphicsHolder.getDefaultLight());
                    graphicsHolder.pop();
                });
            } else {
                MainRenderer.scheduleRender((Identifier)this.texture.identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                    this.storedMatrixTransformations1.transform(graphicsHolder, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.textX, (float)this.y, (float)this.textWidth, (float)this.textHeight, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)GraphicsHolder.getDefaultLight());
                    graphicsHolder.pop();
                });
            }
        }
    }

    private void calculateSize() {
        ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(this.world, this.lift, Init.positionToBlockPos((Position)this.lift.getCurrentFloor().getPosition()));
        String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
        String floorDescription = (String)((ObjectObjectImmutablePair)liftDetails.right()).right();
        this.noFloorNumber = floorNumber.isEmpty();
        this.noFloorDisplay = floorDescription.isEmpty();
        this.gameTick = InitClient.getGameTick();
        if (!this.noFloorNumber || !this.noFloorDisplay) {
            this.text = String.format("%s%s", floorNumber, this.noFloorNumber ? " " : "");
            this.texture = TextureList.instance.renderFont(this.textureId, this.text, this.color, this.font, this.fontSize, this.letterSpacing);
            int rawTextWidth = this.texture.width;
            int rawTextHeight = this.texture.height;
            float scale = (float)rawTextHeight / this.height;
            this.textWidth = (float)rawTextWidth / scale;
            this.textHeight = (float)rawTextHeight / scale;
            this.fixedWidth = this.textWidth / (float)this.text.length() * (float)this.textSize;
        }
    }

    @Override
    public void setStoredMatrixTransformations(StoredMatrixTransformations storedMatrixTransformations) {
        this.storedMatrixTransformations = storedMatrixTransformations;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public void setLetterSpacing(int letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    private void calculateTextPositionX() {
        switch (this.textAlign) {
            case LEFT: {
                this.textX = this.x + this.width - (this.text.length() > this.textSize ? this.fixedWidth : this.textWidth);
                break;
            }
            case CENTER: {
                this.textX = this.x + this.width / 2.0f - (this.text.length() > this.textSize ? this.fixedWidth : this.textWidth) / 2.0f;
                break;
            }
            case RIGHT: {
                this.textX = this.x;
            }
        }
    }

    @Override
    public void setParentDimensions(float parentWidth, float parentHeight) {
    }

    @Override
    public void calculateLayoutWidth() {
    }

    @Override
    public void calculateLayoutHeight() {
    }

    @Override
    public float[] calculateChildGravityOffset(float childWidth, float childHeight, float[] childMargin, Gravity childGravity) {
        return new float[0];
    }

    @Override
    public Object getParentType() {
        return null;
    }

    @Override
    public void setParentType(Object thisObject) {
    }

    @Override
    public float[] getMargin() {
        return new float[]{this.marginLeft, this.marginTop, this.marginRight, this.marginBottom};
    }

    @Override
    public Gravity getGravity() {
        return this.gravity;
    }

    @Override
    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Override
    public void setMargin(float left, float top, float right, float bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setTextScrolling(Boolean needScroll, int textSize, float scrollSpeed) {
        this.needScroll = needScroll;
        this.textSize = textSize;
        this.scrollSpeed = scrollSpeed;
    }

    public void setBasicsAttributes(World world, BlockPos blockPos, Lift lift, Font font, int fontSize, int color) {
        this.world = world;
        this.blockPos = blockPos;
        this.lift = lift;
        this.font = font;
        this.fontSize = fontSize;
        this.color = color;
    }

    public void setTextureId(String textureId) {
        this.textureId = textureId;
    }

    public void addStoredMatrixTransformations(Consumer<GraphicsHolder> transformation) {
        this.transformation = transformation;
    }

    public void setNumberScrolling(Boolean needScroll, float scrollSpeed) {
        this.needScroll = needScroll;
        this.scrollSpeed = scrollSpeed;
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }
}

