/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view.view_group;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.RenderView;

public class LinearLayout
implements RenderView {
    private final Boolean isVertical;
    private final ObjectArrayList<RenderView> children = new ObjectArrayList();
    private World world;
    private BlockPos blockPos;
    private StoredMatrixTransformations storedMatrixTransformations;
    private float width;
    private float height;
    private float marginLeft;
    private float marginTop;
    private float marginRight;
    private float marginBottom;
    private float x;
    private float y;
    private float z;
    private float coordinateOriginX = 0.0f;
    private float coordinateOriginY = 0.0f;
    private Object parentType;
    private float parentWidth;
    private float parentHeight;
    private Gravity gravity;
    private LayoutSize widthType = LayoutSize.WRAP_CONTENT;
    private LayoutSize heightType = LayoutSize.WRAP_CONTENT;
    private String id;
    private int backgroundColor = 0;
    private Consumer<GraphicsHolder> transformation;

    public LinearLayout(Boolean isVertical) {
        this.isVertical = isVertical;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void render() {
        BlockState blockState = this.world.getBlockState(this.blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)DirectionHelper.FACING);
        if (this.transformation != null) {
            this.storedMatrixTransformations.add(this.transformation);
        }
        this.calculateLayoutWidth();
        this.calculateLayoutHeight();
        this.calculateSelfCoordinateOrigin();
        StoredMatrixTransformations storedMatrixTransformations3 = this.storedMatrixTransformations.copy();
        storedMatrixTransformations3.add(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, 0.4368749999534339));
        MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/white.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
            storedMatrixTransformations3.transform(graphicsHolder, offset);
            IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)this.backgroundColor, (int)15);
            graphicsHolder.pop();
        });
        float offset2 = 0.0f;
        float remainingWidth = this.width;
        float remainingHeight = this.height;
        for (RenderView child : this.children) {
            float[] margin = child.getMargin();
            Gravity childGravity = child.getGravity();
            child.setParentType(this);
            child.setStoredMatrixTransformations(this.storedMatrixTransformations);
            if (this.isVertical.booleanValue()) {
                child.setParentDimensions(this.width, remainingHeight);
                child.calculateLayoutWidth();
                child.calculateLayoutHeight();
                childGravityPositionOffset = this.calculateChildGravityOffset(child.getWidth(), child.getHeight(), margin, childGravity);
                remainingHeight -= child.getHeight() + margin[1] + margin[3];
                child.setPosition(this.coordinateOriginX + childGravityPositionOffset[0], this.coordinateOriginY + this.height - margin[1] - child.getHeight() - offset2);
                offset2 += child.getHeight() + margin[1] + margin[3];
            } else {
                child.setParentDimensions(remainingWidth, this.height);
                child.calculateLayoutWidth();
                child.calculateLayoutHeight();
                childGravityPositionOffset = this.calculateChildGravityOffset(child.getWidth(), child.getHeight(), margin, childGravity);
                remainingWidth -= child.getWidth() + margin[0] + margin[2];
                child.setPosition(this.coordinateOriginX + this.width / 2.0f - margin[0] - child.getWidth() - offset2, this.coordinateOriginY + childGravityPositionOffset[1]);
                offset2 += child.getWidth() + margin[0] + margin[2];
            }
            child.render();
        }
    }

    public void addChild(RenderView child) {
        this.children.add((Object)child);
    }

    public void setBasicsAttributes(World world, BlockPos blockPos) {
        this.world = world;
        this.blockPos = blockPos;
        this.storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
    }

    @Override
    public void setStoredMatrixTransformations(StoredMatrixTransformations storedMatrixTransformations) {
        this.storedMatrixTransformations = storedMatrixTransformations;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public float[] getMargin() {
        return new float[]{this.marginLeft, this.marginTop, this.marginRight, this.marginBottom};
    }

    @Override
    public Gravity getGravity() {
        return this.gravity;
    }

    @Override
    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(LayoutSize widthType) {
        this.widthType = widthType;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(LayoutSize heightType) {
        this.heightType = heightType;
    }

    @Override
    public void setMargin(float left, float top, float right, float bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
    }

    @Override
    public void setParentDimensions(float parentWidth, float parentHeight) {
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
    }

    @Override
    public Object getParentType() {
        return this.parentType;
    }

    @Override
    public void setParentType(Object thisObject) {
        this.parentType = thisObject;
    }

    @Override
    public float[] calculateChildGravityOffset(float childWidth, float childHeight, float[] childMargin, Gravity childGravity) {
        float[] offset = new float[2];
        if (childGravity == null) {
            offset = new float[]{this.width / 2.0f - childWidth - childMargin[0], this.height - childHeight - childMargin[1]};
        } else {
            switch (childGravity) {
                case START: {
                    if (!this.isVertical.booleanValue()) break;
                    offset = new float[]{this.width / 2.0f - childWidth - childMargin[0], 0.0f};
                    break;
                }
                case CENTER_VERTICAL: {
                    if (this.isVertical.booleanValue()) break;
                    offset = new float[]{0.0f, (this.height - childHeight) / 2.0f};
                    break;
                }
                case END: {
                    if (!this.isVertical.booleanValue()) break;
                    offset = new float[]{-this.width / 2.0f + childMargin[3], 0.0f};
                    break;
                }
                case TOP: {
                    if (this.isVertical.booleanValue()) break;
                    offset = new float[]{0.0f, this.height - childHeight - childMargin[2]};
                    break;
                }
                case CENTER_HORIZONTAL: {
                    if (!this.isVertical.booleanValue()) break;
                    offset = new float[]{-childWidth / 2.0f, 0.0f};
                    break;
                }
                case BOTTOM: {
                    if (this.isVertical.booleanValue()) break;
                    offset = new float[]{0.0f, childMargin[4]};
                }
            }
        }
        return offset;
    }

    @Override
    public void calculateLayoutWidth() {
        switch (this.widthType) {
            case WRAP_CONTENT: {
                float tempWidth = 0.0f;
                for (RenderView child : this.children) {
                    float[] margin = child.getMargin();
                    if (!this.isVertical.booleanValue()) {
                        child.calculateLayoutWidth();
                        tempWidth += child.getWidth() + margin[0] + margin[2];
                        continue;
                    }
                    child.calculateLayoutWidth();
                    tempWidth = Math.max(tempWidth, child.getWidth() + margin[0] + margin[2]);
                }
                this.width = tempWidth;
                break;
            }
            case MATCH_PARENT: {
                this.width = this.parentWidth;
                break;
            }
            default: {
                this.width = this.widthType.ordinal();
            }
        }
    }

    @Override
    public void calculateLayoutHeight() {
        switch (this.heightType) {
            case WRAP_CONTENT: {
                float tempHeight = 0.0f;
                for (RenderView child : this.children) {
                    float[] margin = child.getMargin();
                    if (this.isVertical.booleanValue()) {
                        child.calculateLayoutHeight();
                        tempHeight += child.getHeight() + margin[1] + margin[3];
                        continue;
                    }
                    child.calculateLayoutHeight();
                    tempHeight = Math.max(tempHeight, child.getHeight() + margin[1] + margin[3]);
                }
                this.height = tempHeight;
                break;
            }
            case MATCH_PARENT: {
                this.height = this.parentHeight;
                break;
            }
            default: {
                this.height = this.heightType.ordinal();
            }
        }
    }

    private void calculateSelfCoordinateOrigin() {
        this.coordinateOriginX = this.x + this.width / 2.0f;
        this.coordinateOriginY = this.y;
    }

    public void addStoredMatrixTransformations(Consumer<GraphicsHolder> transformation) {
        this.transformation = transformation;
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
    }

    public void reverseChildren() {
        ObjectArrayList<RenderView> list = this.children;
        Collections.reverse(list);
    }
}

