/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.packet;

import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockLiftTrackFloor;
import top.xfunny.mod.block.EmptyFloor;

public final class PacketUpdateLiftTrackFloorConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final String floorNumber;
    private final String floorDescription;
    private final boolean shouldDing;

    public PacketUpdateLiftTrackFloorConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        this.floorNumber = packetBufferReceiver.readString();
        this.floorDescription = packetBufferReceiver.readString();
        this.shouldDing = packetBufferReceiver.readBoolean();
    }

    public PacketUpdateLiftTrackFloorConfig(BlockPos blockPos, String floorNumber, String floorDescription, boolean shouldDing) {
        this.blockPos = blockPos;
        this.floorNumber = floorNumber;
        this.floorDescription = floorDescription;
        this.shouldDing = shouldDing;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeString(this.floorNumber);
        packetBufferSender.writeString(this.floorDescription);
        packetBufferSender.writeBoolean(this.shouldDing);
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        if (!Init.isChunkLoaded((World)serverPlayerEntity.getEntityWorld(), (BlockPos)this.blockPos)) {
            return;
        }
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockLiftTrackFloor.BlockEntity) {
            ((BlockLiftTrackFloor.BlockEntity)entity.data).setData(this.floorNumber, this.floorDescription, this.shouldDing);
        } else if (entity != null && entity.data instanceof EmptyFloor.BlockEntity) {
            ((EmptyFloor.BlockEntity)((Object)entity.data)).setData(this.floorNumber, this.floorDescription);
        }
    }
}

