/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockLiftTrackBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketDeleteData;
import top.xfunny.mod.BlockEntityTypes;
import top.xfunny.mod.Init;
import top.xfunny.mod.packet.PacketYTEOpenBlockEntityScreen;

public class EmptyFloor
extends BlockLiftTrackBase
implements BlockWithEntity {
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush((World)world, (PlayerEntity)player, () -> {
            org.mtr.mapping.holder.BlockEntity entity = world.getBlockEntity(pos);
            if (entity != null && entity.data instanceof BlockEntity) {
                ((BlockEntity)((Object)((Object)entity.data))).markDirty2();
                Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), (PacketHandler)new PacketYTEOpenBlockEntityScreen(pos));
            }
        });
    }

    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!world.isClient()) {
            PacketDeleteData.sendDirectlyToServerLiftFloorPosition((ServerWorld)ServerWorld.cast((HolderBase)world), (Position)Init.blockPosToPosition(pos));
        }
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TranslationProvider.TOOLTIP_MTR_LIFT_TRACK_FLOOR.getMutableText(new Object[0]).formatted(TextFormatting.GRAY));
    }

    public ObjectArrayList<Direction> getConnectingDirections(BlockState blockState) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        return ObjectArrayList.of((Object[])new Direction[]{Direction.UP, Direction.DOWN, facing.rotateYClockwise(), facing.rotateYCounterclockwise()});
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        private static final String KEY_FLOOR_NUMBER = "floor_number";
        private static final String KEY_FLOOR_DESCRIPTION = "floor_description";
        private static final String KEY_SHOULD_DING = "should_ding";
        private String floorNumber = "EZ";
        private String floorDescription = "";
        private boolean shouldDing;

        public BlockEntity(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.LIFT_TRACK_EMPTY_FLOOR.get(), pos, state);
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.floorNumber = compoundTag.getString(KEY_FLOOR_NUMBER);
            this.floorDescription = compoundTag.getString(KEY_FLOOR_DESCRIPTION);
            this.shouldDing = compoundTag.getBoolean(KEY_SHOULD_DING);
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putString(KEY_FLOOR_NUMBER, this.floorNumber);
            compoundTag.putString(KEY_FLOOR_DESCRIPTION, this.floorDescription);
            compoundTag.putBoolean(KEY_SHOULD_DING, this.shouldDing);
        }

        public void setData(String floorNumber, String floorDescription) {
            this.floorNumber = floorNumber;
            this.floorDescription = floorDescription;
            this.markDirty2();
        }

        public String getFloorNumber() {
            return this.floorNumber;
        }

        public String getFloorDescription() {
            return this.floorDescription;
        }
    }
}

