/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.block;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import top.xfunny.mod.BlockEntityTypes;
import top.xfunny.mod.Init;
import top.xfunny.mod.Items;
import top.xfunny.mod.block.base.LiftDestinationDispatchTerminalBase;
import top.xfunny.mod.keymapping.DefaultButtonsKeyMapping;
import top.xfunny.mod.util.ArrayListToString;
import top.xfunny.mod.util.TransformPositionX;

public class TestLiftDestinationDispatchTerminal
extends LiftDestinationDispatchTerminalBase {
    public String screenId = "test_lift_destination_dispatch_terminal_key_mapping_home";

    public TestLiftDestinationDispatchTerminal() {
        super(true);
    }

    public static void hasButtonsClient(BlockPos trackPosition, LiftDestinationDispatchTerminalBase.FloorLiftCallback callback) {
        LiftDestinationDispatchTerminalBase.hasButtonsClient(trackPosition, callback);
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)0.1, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)UNLOCKED);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        double hitY = MathHelper.fractionalPart((double)hit.getPos().getYMapped());
        org.mtr.mapping.holder.BlockEntity blockEntity = world.getBlockEntity(pos);
        LiftDestinationDispatchTerminalBase.BlockEntityBase data = (LiftDestinationDispatchTerminalBase.BlockEntityBase)blockEntity.data;
        BlockEntity data1 = (BlockEntity)blockEntity.data;
        DefaultButtonsKeyMapping keyMapping = data.getKeyMapping();
        String focusButton = keyMapping.mapping(TransformPositionX.transform(MathHelper.fractionalPart((double)hit.getPos().getXMapped()), MathHelper.fractionalPart((double)hit.getPos().getZMapped()), IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING)), hitY);
        if (player.isHolding(Items.YTE_LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.isHolding(Items.YTE_LIFT_BUTTONS_LINK_REMOVER.get()) || player.isHolding(Items.YTE_GROUP_LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.isHolding(Items.YTE_GROUP_LIFT_BUTTONS_LINK_REMOVER.get())) {
            return ActionResult.PASS;
        }
        if (this.screenId.equals("test_lift_destination_dispatch_terminal_key_mapping_home")) {
            switch (focusButton) {
                case "number1": {
                    data1.addInputNumber(1);
                    break;
                }
                case "number2": {
                    data1.addInputNumber(2);
                    break;
                }
                case "number3": {
                    data1.addInputNumber(3);
                    break;
                }
                case "number4": {
                    data1.addInputNumber(4);
                    break;
                }
                case "number5": {
                    data1.addInputNumber(5);
                    break;
                }
                case "number6": {
                    data1.addInputNumber(6);
                    break;
                }
                case "number7": {
                    data1.addInputNumber(7);
                    break;
                }
                case "number8": {
                    data1.addInputNumber(8);
                    break;
                }
                case "number9": {
                    data1.addInputNumber(9);
                    break;
                }
                case "number0": {
                    data1.addInputNumber(0);
                    break;
                }
                case "clearNumber": {
                    data1.clearInputNumber();
                    break;
                }
                case "callLift": {
                    ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                    data.callLift(world, pos, ArrayListToString.arrayListToString(data1.getInputNumber()));
                    data1.clearInputNumber();
                    data1.addInputNumber("To Lift:" + data.getLiftIdentifier());
                    scheduler.schedule(() -> {
                        data1.clearInputNumber();
                        data1.addInputNumber("Please input floor number!");
                    }, 1L, TimeUnit.SECONDS);
                    scheduler.shutdown();
                }
            }
            player.sendMessage(Text.of((String)focusButton), true);
            Init.LOGGER.info("focusButton:" + focusButton);
        }
        return ActionResult.SUCCESS;
    }

    public static class BlockEntity
    extends LiftDestinationDispatchTerminalBase.BlockEntityBase {
        public ArrayList<Object> inputNumber = new ArrayList();

        public BlockEntity(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.TEST_LIFT_DESTINATION_DISPATCH_TERMINAL.get(), pos, state);
            super.registerScreenId("test_lift_destination_dispatch_terminal_key_mapping_home");
            this.inputNumber.add("Please input floor number!");
        }

        public void addInputNumber(Object number) {
            if (ArrayListToString.arrayListToString(this.inputNumber).equals("Please input floor number!")) {
                this.clearInputNumber();
            }
            this.inputNumber.add(number);
        }

        public void clearInputNumber() {
            this.inputNumber.clear();
        }

        public ArrayList<Object> getInputNumber() {
            if (this.inputNumber.isEmpty()) {
                this.inputNumber.add("Please input floor number!");
            }
            return this.inputNumber;
        }
    }
}

