/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.block.base;

import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.operation.PressLift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockHelper;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketPressLiftButton;
import top.xfunny.mod.ButtonRegistry;
import top.xfunny.mod.Init;
import top.xfunny.mod.Items;
import top.xfunny.mod.LiftFloorRegistry;
import top.xfunny.mod.LiftLanternController;
import top.xfunny.mod.keymapping.DefaultButtonsKeyMapping;
import top.xfunny.mod.util.TransformPositionX;

public abstract class LiftButtonsBase
extends BlockExtension
implements DirectionHelper,
BlockWithEntity,
IBlock {
    public static final BooleanProperty UNLOCKED = BooleanProperty.of((String)"unlocked");
    public static final BooleanProperty SINGLE = BooleanProperty.of((String)"single");
    public static boolean allowPress;
    private final boolean isOdd;
    private double median = 0.25;

    public LiftButtonsBase(boolean allowPress, boolean isOdd) {
        super(BlockHelper.createBlockSettings((boolean)true, (boolean)true));
        this.isOdd = isOdd;
        LiftButtonsBase.allowPress = allowPress;
    }

    public LiftButtonsBase(boolean allowPress, boolean isOdd, double median) {
        super(BlockHelper.createBlockSettings((boolean)true, (boolean)true));
        this.isOdd = isOdd;
        LiftButtonsBase.allowPress = allowPress;
        this.median = median;
    }

    public static void hasButtonsClient(BlockPos trackPosition, LiftButtonDescriptor descriptor, FloorLiftCallback callback) {
        MinecraftClientData.getInstance().lifts.forEach(lift -> {
            int floorIndex = lift.getFloorIndex(Init.blockPosToPosition(trackPosition));
            if (floorIndex > 0) {
                descriptor.setHasDownButton(true);
            }
            if (floorIndex >= 0 && floorIndex < lift.getFloorCount() - 1) {
                descriptor.setHasUpButton(true);
            }
            if (floorIndex >= 0) {
                callback.accept(floorIndex, (Lift)lift);
            }
        });
    }

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        ActionResult result = IBlock.checkHoldingBrush((World)world, (PlayerEntity)player, () -> {
            boolean unlocked = !IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)UNLOCKED);
            world.setBlockState(pos, state.with(new org.mtr.mapping.holder.Property((Property)LiftButtonsBase.UNLOCKED.data), (Comparable)Boolean.valueOf(unlocked)));
            player.sendMessage(Text.of((String)(unlocked ? "\u5df2\u89e3\u9501" : "\u5df2\u9501\u5b9a")), true);
        });
        if (result == ActionResult.SUCCESS) {
            return ActionResult.SUCCESS;
        }
        if (player.isHolding(Items.YTE_LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.isHolding(Items.YTE_LIFT_BUTTONS_LINK_REMOVER.get()) || player.isHolding(Items.YTE_GROUP_LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.isHolding(Items.YTE_GROUP_LIFT_BUTTONS_LINK_REMOVER.get())) {
            return ActionResult.PASS;
        }
        boolean unlocked = IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)UNLOCKED);
        double hitY = MathHelper.fractionalPart((double)hit.getPos().getYMapped());
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockEntityBase data = (BlockEntityBase)blockEntity.data;
        DefaultButtonsKeyMapping keyMapping = data.getKeyMapping();
        String focusButton = keyMapping.mapping(TransformPositionX.transform(MathHelper.fractionalPart((double)hit.getPos().getXMapped()), MathHelper.fractionalPart((double)hit.getPos().getZMapped()), IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING)), hitY);
        Init.LOGGER.info(focusButton);
        if (unlocked) {
            if (world.isClient() && !focusButton.equals("null")) {
                ObjectOpenHashSet<BlockPos> connectedLanternPositions = data.getLiftButtonPositions();
                LiftButtonDescriptor descriptor = new LiftButtonDescriptor(false, false);
                data.trackPositions.forEach(trackPosition -> LiftButtonsBase.hasButtonsClient(trackPosition, descriptor, (floor, lift) -> {}));
                connectedLanternPositions.forEach(lanternPos -> {
                    BlockEntity lanternBlockEntity = world.getBlockEntity(lanternPos);
                    if (lanternBlockEntity != null && lanternBlockEntity.data instanceof BlockEntityBase) {
                        BlockEntityBase lanternData = (BlockEntityBase)lanternBlockEntity.data;
                        if (descriptor.hasDownButton() && descriptor.hasUpButton()) {
                            if (focusButton.equals("down")) {
                                lanternData.setPressedButtonDirection(LiftDirection.DOWN);
                            } else if (focusButton.equals("up")) {
                                lanternData.setPressedButtonDirection(LiftDirection.UP);
                            }
                        } else {
                            lanternData.setPressedButtonDirection(descriptor.hasDownButton() ? LiftDirection.DOWN : LiftDirection.UP);
                        }
                    }
                });
                data.liftDirection = descriptor.hasDownButton() && descriptor.hasUpButton() ? (focusButton.equals("up") ? LiftDirection.UP : (focusButton.equals("down") ? LiftDirection.DOWN : LiftDirection.NONE)) : (descriptor.hasDownButton() ? LiftDirection.DOWN : LiftDirection.UP);
                PressLift pressLift = new PressLift();
                data.trackPositions.forEach(trackPosition -> pressLift.add(Init.blockPosToPosition(trackPosition), data.liftDirection));
                InitClient.REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new PacketPressLiftButton(pressLift));
                return ActionResult.SUCCESS;
            }
            return ActionResult.SUCCESS;
        }
        System.out.println(allowPress);
        return ActionResult.FAIL;
    }

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction facing = ctx.getPlayerFacing();
        if (!this.isOdd) {
            return IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)facing.rotateYClockwise(), (int)2) ? this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)LiftButtonsBase.FACING.data), (Comparable)facing.data).with(new org.mtr.mapping.holder.Property((Property)LiftButtonsBase.SIDE.data), (Comparable)IBlock.EnumSide.LEFT) : null;
        }
        return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)LiftButtonsBase.FACING.data), (Comparable)facing.data);
    }

    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClient()) {
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
            if (!this.isOdd) {
                world.setBlockState(pos.offset(facing.rotateYClockwise()), this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)LiftButtonsBase.FACING.data), (Comparable)facing.data).with(new org.mtr.mapping.holder.Property((Property)LiftButtonsBase.SIDE.data), (Comparable)IBlock.EnumSide.RIGHT), 3);
            }
            world.updateNeighbors(pos, Blocks.getAirMapped());
            state.updateNeighbors(new WorldAccess((LevelAccessor)world.data), pos, 3);
        }
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!this.isOdd) {
            if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE) == IBlock.EnumSide.RIGHT) {
                IBlock.onBreakCreative((World)world, (PlayerEntity)player, (BlockPos)pos.offset(IBlock.getSideDirection((BlockState)state)));
            } else if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE) == IBlock.EnumSide.LEFT) {
                IBlock.onBreakCreative((World)world, (PlayerEntity)player, (BlockPos)pos.offset(IBlock.getSideDirection((BlockState)state)));
            }
        }
        super.onBreak2(world, pos, state, player);
    }

    public static class LiftButtonDescriptor {
        private boolean hasUpButton;
        private boolean hasDownButton;

        public LiftButtonDescriptor(boolean hasUpButton, boolean hasDownButton) {
            this.hasDownButton = hasDownButton;
            this.hasUpButton = hasUpButton;
        }

        public boolean hasUpButton() {
            return this.hasUpButton;
        }

        public boolean hasDownButton() {
            return this.hasDownButton;
        }

        public void setHasUpButton(boolean hasUpButton) {
            this.hasUpButton = hasUpButton;
        }

        public void setHasDownButton(boolean hasDownButton) {
            this.hasDownButton = hasDownButton;
        }
    }

    @FunctionalInterface
    public static interface FloorLiftCallback {
        public void accept(int var1, Lift var2);
    }

    public static class BlockEntityBase
    extends BlockEntityExtension
    implements LiftFloorRegistry,
    ButtonRegistry,
    LiftLanternController {
        private static final String KEY_TRACK_FLOOR_POS = "track_floor_pos";
        private static final String KEY_LIFT_BUTTON_POSITIONS = "lift_button_position";
        public final ObjectOpenHashSet<BlockPos> liftButtonPositions = new ObjectOpenHashSet();
        private final ObjectOpenHashSet<BlockPos> trackPositions = new ObjectOpenHashSet();
        public LiftDirection liftDirection = LiftDirection.NONE;
        public BlockPos selfPos;
        private LiftDirection pressedButtonDirection;
        private DefaultButtonsKeyMapping keyMapping = new DefaultButtonsKeyMapping();

        public BlockEntityBase(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
            super(type, blockPos, blockState);
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.trackPositions.clear();
            this.liftButtonPositions.clear();
            for (long position : compoundTag.getLongArray(KEY_TRACK_FLOOR_POS)) {
                this.trackPositions.add((Object)BlockPos.fromLong((long)position));
            }
            for (long position : compoundTag.getLongArray(KEY_LIFT_BUTTON_POSITIONS)) {
                this.liftButtonPositions.add((Object)BlockPos.fromLong((long)position));
            }
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            ArrayList trackPositionsList = new ArrayList();
            this.trackPositions.forEach(position -> trackPositionsList.add(position.asLong()));
            compoundTag.putLongArray(KEY_TRACK_FLOOR_POS, trackPositionsList);
            ArrayList liftButtonPositionsList = new ArrayList();
            this.liftButtonPositions.forEach(position -> liftButtonPositionsList.add(position.asLong()));
            compoundTag.putLongArray(KEY_LIFT_BUTTON_POSITIONS, liftButtonPositionsList);
        }

        public DefaultButtonsKeyMapping getKeyMapping() {
            return this.keyMapping;
        }

        public void setKeyMapping(DefaultButtonsKeyMapping keyMapping) {
            this.keyMapping = keyMapping;
        }

        @Override
        public void registerFloor(BlockPos selfPos, World world, BlockPos pos, boolean isAdd) {
            this.selfPos = selfPos;
            boolean single = IBlock.getStatePropertySafe((BlockState)world.getBlockState(selfPos), (BooleanProperty)SINGLE);
            if (IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (EnumProperty)IBlock.SIDE) == IBlock.EnumSide.RIGHT) {
                BlockEntity blockEntity = world.getBlockEntity(this.getPos2().offset(IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (DirectionProperty)DirectionHelper.FACING).rotateYCounterclockwise()));
                if (blockEntity != null && blockEntity.data instanceof BlockEntityBase) {
                    ((BlockEntityBase)blockEntity.data).registerFloor(selfPos, world, pos, isAdd);
                }
            } else if (isAdd) {
                this.trackPositions.add((Object)pos);
                if (this.trackPositions.size() != 1 && single) {
                    boolean single1 = !IBlock.getStatePropertySafe((BlockState)world.getBlockState(selfPos), (BooleanProperty)SINGLE);
                    world.setBlockState(selfPos, world.getBlockState(selfPos).with(new org.mtr.mapping.holder.Property((Property)LiftButtonsBase.SINGLE.data), (Comparable)Boolean.valueOf(single1)));
                }
            } else {
                this.trackPositions.remove((Object)pos);
                if (this.trackPositions.size() == 1 && !single) {
                    boolean single1 = !IBlock.getStatePropertySafe((BlockState)world.getBlockState(selfPos), (BooleanProperty)SINGLE);
                    world.setBlockState(selfPos, world.getBlockState(selfPos).with(new org.mtr.mapping.holder.Property((Property)LiftButtonsBase.SINGLE.data), (Comparable)Boolean.valueOf(single1)));
                }
            }
            this.markDirty2();
        }

        @Override
        public void registerButton(World world, BlockPos blockPos, boolean isAdd) {
            if (IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (EnumProperty)IBlock.SIDE) == IBlock.EnumSide.RIGHT) {
                BlockEntity blockEntity = world.getBlockEntity(this.getPos2().offset(IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (DirectionProperty)DirectionHelper.FACING).rotateYCounterclockwise()));
                if (blockEntity != null && blockEntity.data instanceof BlockEntityBase) {
                    ((BlockEntityBase)blockEntity.data).registerButton(world, blockPos, isAdd);
                }
            } else if (isAdd) {
                this.liftButtonPositions.add((Object)blockPos);
            } else {
                this.liftButtonPositions.remove((Object)blockPos);
            }
            this.markDirty2();
        }

        public void forEachTrackPosition(Consumer<BlockPos> consumer) {
            this.trackPositions.forEach(consumer);
        }

        @Override
        public void forEachLiftButtonPosition(Consumer<BlockPos> consumer) {
            this.liftButtonPositions.forEach(consumer);
        }

        @Override
        public ObjectOpenHashSet<BlockPos> getLiftButtonPositions() {
            return this.liftButtonPositions;
        }

        @Override
        public LiftDirection getPressedButtonDirection() {
            return this.pressedButtonDirection;
        }

        public void setPressedButtonDirection(LiftDirection direction) {
            this.pressedButtonDirection = direction;
        }
    }
}

