/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.block.base;

import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.data.Lift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockHelper;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.MinecraftClientData;
import top.xfunny.mod.Init;
import top.xfunny.mod.Items;
import top.xfunny.mod.LiftFloorRegistry;
import top.xfunny.mod.block.base.LiftButtonsBase;

public abstract class LiftPanelBase
extends BlockExtension
implements DirectionHelper,
BlockWithEntity,
IBlock {
    private final boolean isOdd;

    public LiftPanelBase(Boolean isOdd) {
        super(BlockHelper.createBlockSettings((boolean)true, (boolean)true));
        this.isOdd = isOdd;
    }

    public static void LiftCheck(BlockPos trackPosition, LiftButtonsBase.FloorLiftCallback callback) {
        MinecraftClientData.getInstance().lifts.forEach(lift -> {
            int floorIndex = lift.getFloorIndex(Init.blockPosToPosition(trackPosition));
            if (floorIndex >= 0) {
                callback.accept(floorIndex, (Lift)lift);
            }
        });
    }

    public static void hasButtonsClient(BlockPos trackPosition, boolean[] buttonStates, LiftButtonsBase.FloorLiftCallback callback) {
        MinecraftClientData.getInstance().lifts.forEach(lift -> {
            int floorIndex = lift.getFloorIndex(Init.blockPosToPosition(trackPosition));
            if (floorIndex > 0) {
                buttonStates[0] = true;
            }
            if (floorIndex >= 0 && floorIndex < lift.getFloorCount() - 1) {
                buttonStates[1] = true;
            }
            if (floorIndex >= 0) {
                callback.accept(floorIndex, (Lift)lift);
            }
        });
    }

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        if (player.isHolding(Items.YTE_LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.isHolding(Items.YTE_LIFT_BUTTONS_LINK_REMOVER.get())) {
            return ActionResult.PASS;
        }
        return ActionResult.FAIL;
    }

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction facing = ctx.getPlayerFacing();
        if (!this.isOdd) {
            return IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)facing.rotateYClockwise(), (int)2) ? this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)LiftPanelBase.FACING.data), (Comparable)facing.data).with(new org.mtr.mapping.holder.Property((Property)LiftPanelBase.SIDE.data), (Comparable)IBlock.EnumSide.LEFT) : null;
        }
        return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)LiftPanelBase.FACING.data), (Comparable)facing.data);
    }

    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClient()) {
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
            if (!this.isOdd) {
                world.setBlockState(pos.offset(facing.rotateYClockwise()), this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)LiftPanelBase.FACING.data), (Comparable)facing.data).with(new org.mtr.mapping.holder.Property((Property)LiftPanelBase.SIDE.data), (Comparable)IBlock.EnumSide.RIGHT), 3);
            }
            world.updateNeighbors(pos, Blocks.getAirMapped());
            state.updateNeighbors(new WorldAccess((LevelAccessor)world.data), pos, 3);
        }
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!this.isOdd) {
            if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE) == IBlock.EnumSide.RIGHT) {
                IBlock.onBreakCreative((World)world, (PlayerEntity)player, (BlockPos)pos.offset(IBlock.getSideDirection((BlockState)state)));
            } else if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE) == IBlock.EnumSide.LEFT) {
                IBlock.onBreakCreative((World)world, (PlayerEntity)player, (BlockPos)pos.offset(IBlock.getSideDirection((BlockState)state)));
            }
        }
        super.onBreak2(world, pos, state, player);
    }

    public static class BlockEntityBase
    extends BlockEntityExtension
    implements LiftFloorRegistry {
        private static final String KEY_TRACK_FLOOR_POS = "track_floor_pos";
        private final ObjectOpenHashSet<BlockPos> trackPositions = new ObjectOpenHashSet();

        public BlockEntityBase(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
            super(type, blockPos, blockState);
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.trackPositions.clear();
            for (long position : compoundTag.getLongArray(KEY_TRACK_FLOOR_POS)) {
                this.trackPositions.add((Object)BlockPos.fromLong((long)position));
            }
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            ArrayList trackPositionsList = new ArrayList();
            this.trackPositions.forEach(position -> trackPositionsList.add(position.asLong()));
            compoundTag.putLongArray(KEY_TRACK_FLOOR_POS, trackPositionsList);
        }

        @Override
        public void registerFloor(BlockPos selfPos, World world, BlockPos pos, boolean isAdd) {
            if (IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (EnumProperty)IBlock.SIDE) == IBlock.EnumSide.RIGHT) {
                BlockEntity blockEntity = world.getBlockEntity(this.getPos2().offset(IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (DirectionProperty)DirectionHelper.FACING).rotateYCounterclockwise()));
                if (blockEntity != null && blockEntity.data instanceof LiftButtonsBase.BlockEntityBase) {
                    ((LiftButtonsBase.BlockEntityBase)blockEntity.data).registerFloor(selfPos, world, pos, isAdd);
                }
            } else if (isAdd) {
                this.trackPositions.add((Object)pos);
            } else {
                this.trackPositions.remove((Object)pos);
            }
            this.markDirty2();
        }

        public void forEachTrackPosition(Consumer<BlockPos> consumer) {
            this.trackPositions.forEach(consumer);
        }

        @Nullable
        public ObjectOpenHashSet<BlockPos> getTrackPosition() {
            return this.trackPositions;
        }
    }
}

