/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client;

import java.awt.Font;
import java.util.Locale;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageFormat;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;
import top.xfunny.mod.client.DynamicTextureCache;

public class YteRouteMapGenerator
implements IGui {
    private static int scale;
    private static int lineSize;
    private static int fontSizeBig;
    private static int fontSizeSmall;

    public static NativeImage generateImage(String text, int textColor, Font font, float fontSize, int padding, int letterSpacing) {
        YteRouteMapGenerator.setConstants();
        try {
            int height = Math.round((float)scale * 1.5f);
            int[] dimensions = new int[2];
            byte[] pixels = DynamicTextureCache.instance.getTextPixels(text.toUpperCase(Locale.ENGLISH), dimensions, 90, (float)fontSizeSmall * fontSize, padding, font, letterSpacing);
            int totalWidth = DynamicTextureCache.instance.totalWidth;
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), totalWidth, height, true);
            nativeImage.fillRect(0, 0, totalWidth, height, 0);
            YteRouteMapGenerator.drawString(nativeImage, pixels, totalWidth / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, textColor, false);
            return nativeImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setConstants() {
        scale = (int)Math.pow(2.0, Config.getClient().getDynamicTextureResolution() + 5);
        lineSize = scale / 8;
        fontSizeBig = lineSize * 2;
        fontSizeSmall = fontSizeBig / 2;
    }

    public static void drawString(NativeImage nativeImage, byte[] pixels, int x, int y, int[] textDimensions, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, int backgroundColor, int textColor, boolean rotate90) {
        int drawY;
        int drawX;
        if ((backgroundColor >> 24 & 0xFF) > 0) {
            for (drawX = 0; drawX < textDimensions[rotate90 ? 1 : 0]; ++drawX) {
                for (drawY = 0; drawY < textDimensions[rotate90 ? 0 : 1]; ++drawY) {
                    YteRouteMapGenerator.drawPixelSafe(nativeImage, (int)horizontalAlignment.getOffset((float)(drawX + x), (float)textDimensions[rotate90 ? 1 : 0]), (int)verticalAlignment.getOffset((float)(drawY + y), (float)textDimensions[rotate90 ? 0 : 1]), backgroundColor);
                }
            }
        }
        drawX = 0;
        drawY = rotate90 ? textDimensions[0] - 1 : 0;
        for (int i = 0; i < textDimensions[0] * textDimensions[1]; ++i) {
            YteRouteMapGenerator.blendPixel(nativeImage, (int)horizontalAlignment.getOffset((float)(x + drawX), (float)textDimensions[rotate90 ? 1 : 0]), (int)verticalAlignment.getOffset((float)(y + drawY), (float)textDimensions[rotate90 ? 0 : 1]), ((pixels[i] & 0xFF) << 24) + (textColor & 0xFFFFFF));
            if (rotate90) {
                if (--drawY >= 0) continue;
                drawY = textDimensions[0] - 1;
                ++drawX;
                continue;
            }
            if (++drawX != textDimensions[0]) continue;
            drawX = 0;
            ++drawY;
        }
    }

    private static void blendPixel(NativeImage nativeImage, int x, int y, int color) {
        if (Utilities.isBetween((double)x, (double)0.0, (double)(nativeImage.getWidth() - 1)) && Utilities.isBetween((double)y, (double)0.0, (double)(nativeImage.getHeight() - 1))) {
            int existingPixel = nativeImage.getColor(x, y);
            int a1 = existingPixel >> 24 & 0xFF;
            int r1 = existingPixel & 0xFF;
            int g1 = existingPixel >> 8 & 0xFF;
            int b1 = existingPixel >> 16 & 0xFF;
            int a2 = color >>> 24 & 0xFF;
            int r2 = color >> 16 & 0xFF;
            int g2 = color >> 8 & 0xFF;
            int b2 = color & 0xFF;
            if (a1 == 0) {
                if (a2 > 0) {
                    float alpha = (float)a2 / 255.0f;
                    int r = (int)((float)r2 * alpha);
                    int g = (int)((float)g2 * alpha);
                    int b = (int)((float)b2 * alpha);
                    int finalColor = a2 << 24 | b << 16 | g << 8 | r;
                    nativeImage.setPixelColor(x, y, finalColor);
                }
            } else {
                float alpha1 = (float)a1 / 255.0f;
                float alpha2 = (float)a2 / 255.0f;
                float outAlpha = alpha1 + alpha2 * (1.0f - alpha1);
                if (outAlpha > 0.0f) {
                    float factor = alpha2 * (1.0f - alpha1) / outAlpha;
                    int r = (int)((float)r1 * (1.0f - factor) + (float)r2 * factor);
                    int g = (int)((float)g1 * (1.0f - factor) + (float)g2 * factor);
                    int b = (int)((float)b1 * (1.0f - factor) + (float)b2 * factor);
                    int a = (int)(outAlpha * 255.0f);
                    int finalColor = a << 24 | b << 16 | g << 8 | r;
                    nativeImage.setPixelColor(x, y, finalColor);
                }
            }
        }
    }

    private static void drawPixelSafe(NativeImage nativeImage, int x, int y, int color) {
        if (Utilities.isBetween((double)x, (double)0.0, (double)(nativeImage.getWidth() - 1)) && Utilities.isBetween((double)y, (double)0.0, (double)(nativeImage.getHeight() - 1))) {
            nativeImage.setPixelColor(x, y, color);
        }
    }
}

