/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.KoneKDS330Button1;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.ButtonView;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.ImageView;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftArrowView;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.keymapping.DefaultButtonsKeyMapping;
import top.xfunny.mod.util.ReverseRendering;

public class RenderKoneKDS330Button1
extends BlockEntityRenderer<KoneKDS330Button1.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private static final int HOVER_COLOR = -3355444;
    private static final int PRESSED_COLOR = -1;
    private static final int DEFAULT_COLOR = -1;
    private static final Identifier ARROW_TEXTURE = new Identifier("yte", "textures/block/kone_arrow_light.png");
    private static final BooleanProperty UNLOCKED = BooleanProperty.of((String)"unlocked");
    private final Identifier BUTTON_TEXTURE_UP = new Identifier("yte", "textures/block/kone_kds330_up_button.png");
    private final Identifier BUTTON_TEXTURE_DOWN = new Identifier("yte", "textures/block/kone_kds330_up_button.png");
    private final Identifier BUTTON_LIGHT_TEXTURE_UP = new Identifier("yte", "textures/block/kone_kds330_up_button_light.png");
    private final Identifier BUTTON_LIGHT_TEXTURE_DOWN = new Identifier("yte", "textures/block/kone_kds330_up_button_light.png");

    public RenderKoneKDS330Button1(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(KoneKDS330Button1.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        boolean unlocked = IBlock.getStatePropertySafe((BlockState)blockState, (BooleanProperty)UNLOCKED);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.465625f);
        });
        DefaultButtonsKeyMapping keyMapping = blockEntity.getKeyMapping();
        FrameLayout screenContainer = new FrameLayout();
        screenContainer.setBasicsAttributes(world, blockPos);
        screenContainer.setStoredMatrixTransformations(storedMatrixTransformations1);
        screenContainer.setParentDimensions(0.28125f, 0.1875f);
        screenContainer.setPosition(-0.140625f, 0.2359375f);
        screenContainer.setWidth(LayoutSize.MATCH_PARENT);
        screenContainer.setHeight(LayoutSize.MATCH_PARENT);
        FrameLayout buttonUpLayout = new FrameLayout();
        buttonUpLayout.setBasicsAttributes(world, blockPos);
        buttonUpLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        buttonUpLayout.setParentDimensions(0.28125f, 0.190625f);
        buttonUpLayout.setPosition(-0.140625f, 0.4234375f);
        buttonUpLayout.setWidth(LayoutSize.MATCH_PARENT);
        buttonUpLayout.setHeight(LayoutSize.MATCH_PARENT);
        FrameLayout buttonDownLayout = new FrameLayout();
        buttonDownLayout.setBasicsAttributes(world, blockPos);
        buttonDownLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        buttonDownLayout.setParentDimensions(0.28125f, 0.190625f);
        buttonDownLayout.setPosition(-0.140625f, 0.0453125f);
        buttonDownLayout.setWidth(LayoutSize.MATCH_PARENT);
        buttonDownLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout screenLayout = new LinearLayout(false);
        screenLayout.setBasicsAttributes(world, blockPos);
        screenLayout.setWidth(LayoutSize.WRAP_CONTENT);
        screenLayout.setHeight(LayoutSize.WRAP_CONTENT);
        screenLayout.setGravity(Gravity.CENTER);
        screenLayout.setMargin(0.0f, 0.0f, 0.0f, 0.0f);
        FrameLayout buttonUpGroup = new FrameLayout();
        buttonUpGroup.setBasicsAttributes(world, blockPos);
        buttonUpGroup.setWidth(LayoutSize.WRAP_CONTENT);
        buttonUpGroup.setHeight(LayoutSize.WRAP_CONTENT);
        buttonUpGroup.setGravity(Gravity.CENTER);
        FrameLayout buttonDownGroup = new FrameLayout();
        buttonDownGroup.setBasicsAttributes(world, blockPos);
        buttonDownGroup.setWidth(LayoutSize.WRAP_CONTENT);
        buttonDownGroup.setHeight(LayoutSize.WRAP_CONTENT);
        buttonDownGroup.setGravity(Gravity.CENTER);
        ImageView buttonUp = new ImageView();
        buttonUp.setBasicsAttributes(world, blockPos);
        buttonUp.setTexture(this.BUTTON_TEXTURE_UP);
        buttonUp.setDimension(0.05625f);
        buttonUp.setGravity(Gravity.CENTER);
        buttonUp.setLight(light);
        ButtonView buttonUpLight = new ButtonView();
        buttonUpLight.setId("up");
        buttonUpLight.setBasicsAttributes(world, blockPos, keyMapping);
        buttonUpLight.setTexture(this.BUTTON_LIGHT_TEXTURE_UP);
        buttonUpLight.setDimension(0.05625f);
        buttonUpLight.setGravity(Gravity.CENTER);
        buttonUpLight.setLight(light);
        buttonUpLight.setDefaultColor(-1);
        buttonUpLight.setHoverColor(-3355444);
        buttonUpLight.setPressedColor(-1);
        ImageView buttonDown = new ImageView();
        buttonDown.setBasicsAttributes(world, blockPos);
        buttonDown.setTexture(this.BUTTON_TEXTURE_DOWN);
        buttonDown.setDimension(0.05625f);
        buttonDown.setGravity(Gravity.CENTER);
        buttonDown.setLight(light);
        buttonDown.setFlip(false, true);
        ButtonView buttonDownLight = new ButtonView();
        buttonDownLight.setId("down");
        buttonDownLight.setBasicsAttributes(world, blockPos, keyMapping);
        buttonDownLight.setTexture(this.BUTTON_LIGHT_TEXTURE_DOWN);
        buttonDownLight.setDimension(0.05625f);
        buttonDownLight.setGravity(Gravity.CENTER);
        buttonDownLight.setLight(light);
        buttonDownLight.setDefaultColor(-1);
        buttonDownLight.setHoverColor(-3355444);
        buttonDownLight.setPressedColor(-1);
        buttonDownLight.setFlip(false, true);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            KoneKDS330Button1.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                instructionDirections.forEach(liftDirection -> {
                    switch (liftDirection) {
                        case DOWN: {
                            buttonDownLight.activate();
                            break;
                        }
                        case UP: {
                            buttonUpLight.activate();
                        }
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            int count = Math.min(2, sortedPositionsAndLifts.size());
            boolean reverseRendering = count > 1 && ReverseRendering.reverseRendering(facing.rotateYCounterclockwise(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(0)).left(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(1)).left());
            for (int i = 0; i < count; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("kone-lcd-segment"), 6.0f, -1);
                liftFloorDisplayView.setTextureId("kone-kds-330-lcd-segment");
                liftFloorDisplayView.setWidth(0.1125f);
                liftFloorDisplayView.setHeight(0.10625f);
                liftFloorDisplayView.setMargin(-0.015625f, 0.0f, 0.025f, 0.0f);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.RIGHT);
                LiftArrowView liftArrowView = new LiftArrowView();
                liftArrowView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), LiftArrowView.ArrowType.AUTO);
                liftArrowView.setTexture(ARROW_TEXTURE);
                liftArrowView.setDimension(0.05f);
                liftArrowView.setMargin(0.0f, 0.0f, 0.0f, 0.0f);
                liftArrowView.setGravity(Gravity.CENTER_HORIZONTAL);
                liftArrowView.setQueuedRenderLayer(QueuedRenderLayer.LIGHT_TRANSLUCENT);
                if (unlocked) {
                    liftArrowView.setColor(-1);
                } else {
                    liftArrowView.setColor(-16777216);
                }
                LinearLayout numberLayout = new LinearLayout(true);
                numberLayout.setBasicsAttributes(world, blockPos);
                numberLayout.setWidth(LayoutSize.WRAP_CONTENT);
                numberLayout.setHeight(LayoutSize.WRAP_CONTENT);
                numberLayout.addChild(liftArrowView);
                numberLayout.addChild(liftFloorDisplayView);
                if (reverseRendering) {
                    screenLayout.addChild(numberLayout);
                    screenLayout.reverseChildren();
                    continue;
                }
                screenLayout.addChild(numberLayout);
            }
        }
        screenContainer.addChild(screenLayout);
        if (buttonDescriptor.hasUpButton()) {
            buttonUpGroup.addChild(buttonUp);
            buttonUpGroup.addChild(buttonUpLight);
            buttonUpLayout.addChild(buttonUpGroup);
        }
        if (buttonDescriptor.hasDownButton()) {
            buttonDownGroup.addChild(buttonDown);
            buttonDownGroup.addChild(buttonDownLight);
            buttonDownLayout.addChild(buttonDownGroup);
        }
        buttonDownLayout.render();
        buttonUpLayout.render();
        screenContainer.render();
    }
}

