/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.KoneMScreen1Even;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.ButtonView;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.util.ClientGetLiftDetails;

public class RenderKoneMScreen1<T extends LiftButtonsBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private static final int PRESSED_COLOR = -3386027;
    private static final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/kone_m_lantern_arrow_1.png");
    private final boolean isOdd;

    public RenderKoneMScreen1(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.490625f);
        });
        LinearLayout parentLayout = new LinearLayout(false);
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.78125f, 0.203125f);
        parentLayout.setPosition(this.isOdd ? -0.390625f : -0.890625f, 0.625f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        ButtonView upLantern = new ButtonView();
        upLantern.setBasicsAttributes(world, blockPos);
        upLantern.setTexture(BUTTON_TEXTURE);
        upLantern.setDimension(0.125f);
        upLantern.setGravity(Gravity.CENTER_VERTICAL);
        upLantern.setLight(light);
        upLantern.setDefaultColor(-1);
        upLantern.setPressedColor(-3386027);
        upLantern.setMargin(0.0625f, 0.0f, 0.1875f, 0.0f);
        ButtonView upLantern1 = new ButtonView();
        upLantern1.setBasicsAttributes(world, blockPos);
        upLantern1.setTexture(BUTTON_TEXTURE);
        upLantern1.setDimension(0.125f);
        upLantern1.setGravity(Gravity.CENTER_VERTICAL);
        upLantern1.setLight(light);
        upLantern1.setDefaultColor(-1);
        upLantern1.setPressedColor(-3386027);
        upLantern1.setMargin(0.0f, 0.0f, 0.075f, 0.0f);
        ButtonView downLantern = new ButtonView();
        downLantern.setBasicsAttributes(world, blockPos);
        downLantern.setTexture(BUTTON_TEXTURE);
        downLantern.setDimension(0.125f);
        downLantern.setGravity(Gravity.CENTER_VERTICAL);
        downLantern.setLight(light);
        downLantern.setDefaultColor(-1);
        downLantern.setPressedColor(-3386027);
        downLantern.setMargin(0.0625f, 0.0f, 0.1875f, 0.0f);
        downLantern.setFlip(false, true);
        ButtonView downLantern1 = new ButtonView();
        downLantern1.setBasicsAttributes(world, blockPos);
        downLantern1.setTexture(BUTTON_TEXTURE);
        downLantern1.setDimension(0.125f);
        downLantern1.setGravity(Gravity.CENTER_VERTICAL);
        downLantern1.setLight(light);
        downLantern1.setDefaultColor(-1);
        downLantern1.setPressedColor(-3386027);
        downLantern1.setFlip(false, true);
        downLantern1.setMargin(0.0f, 0.0f, 0.075f, 0.0f);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        LineComponent buttonLine = new LineComponent();
        buttonLine.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            KoneMScreen1Even.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                LiftDirection pressedButtonDirection = blockEntity.getPressedButtonDirection();
                ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
                String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
                String currentFloorNumber = (String)((ObjectObjectImmutablePair)RenderLifts.getLiftDetails((World)world, (Lift)lift, (BlockPos)trackPosition).right()).left();
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                if (instructionDirections.isEmpty() && pressedButtonDirection != null && lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                    switch (pressedButtonDirection) {
                        case DOWN: {
                            downLantern.activate();
                            downLantern1.activate();
                            break;
                        }
                        case UP: {
                            upLantern.activate();
                            upLantern1.activate();
                        }
                    }
                }
                instructionDirections.forEach(liftDirection -> {
                    if (lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                        if (liftDirection == LiftDirection.NONE) {
                            if (pressedButtonDirection != null) {
                                switch (pressedButtonDirection) {
                                    case DOWN: {
                                        downLantern.activate();
                                        downLantern1.activate();
                                        break;
                                    }
                                    case UP: {
                                        upLantern.activate();
                                        upLantern1.activate();
                                    }
                                }
                            }
                        } else {
                            switch (liftDirection) {
                                case DOWN: {
                                    downLantern.activate();
                                    downLantern1.activate();
                                    break;
                                }
                                case UP: {
                                    upLantern.activate();
                                    upLantern1.activate();
                                }
                            }
                        }
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (buttonDescriptor.hasDownButton() && buttonDescriptor.hasUpButton()) {
            parentLayout.addChild(upLantern);
            parentLayout.addChild(downLantern1);
        } else if (buttonDescriptor.hasDownButton()) {
            parentLayout.addChild(downLantern);
            parentLayout.addChild(downLantern1);
        } else if (buttonDescriptor.hasUpButton()) {
            parentLayout.addChild(upLantern);
            parentLayout.addChild(upLantern1);
        }
        if (!sortedPositionsAndLifts.isEmpty()) {
            boolean count = true;
            for (int i = 0; i < 1; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("kone-m-series"), 7.0f, -65536);
                liftFloorDisplayView.setDisplayLength(2, 0.0f);
                liftFloorDisplayView.setTextureId("kone_m_screen_1");
                liftFloorDisplayView.setWidth(0.125f);
                liftFloorDisplayView.setHeight(0.125f);
                liftFloorDisplayView.setGravity(Gravity.CENTER_VERTICAL);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.RIGHT);
                parentLayout.addChild(liftFloorDisplayView);
            }
        }
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachLiftButtonPosition(buttonPosition -> buttonLine.RenderLine(holdingLinker, (BlockPos)buttonPosition, true));
        parentLayout.render();
    }
}

