/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.mapper.WorldHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.MitsubishiNexWayScreen2Even;
import top.xfunny.mod.block.base.LiftPanelBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftArrowView;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;

public class RenderMitsubishiNexWayScreen2<T extends LiftPanelBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private final boolean isOdd;

    public RenderMitsubishiNexWayScreen2(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.490625f);
        });
        LinearLayout parentLayout = new LinearLayout(true);
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.234375f, 0.171875f);
        parentLayout.setPosition(this.isOdd ? -0.1171875f : -0.6171875f, 0.6171875f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout numberLayout = new LinearLayout(false);
        numberLayout.setBasicsAttributes(world, blockPos);
        numberLayout.setWidth(LayoutSize.WRAP_CONTENT);
        numberLayout.setHeight(LayoutSize.WRAP_CONTENT);
        numberLayout.setMargin(0.01f, 0.021875f, 0.0f, 0.0f);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        ((LiftPanelBase.BlockEntityBase)blockEntity).forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            MitsubishiNexWayScreen2Even.LiftCheck(trackPosition, (floorIndex, lift) -> sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift)));
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            boolean count = true;
            for (int i = 0; i < 1; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("gill_sans_mt"), 16.0f, -1);
                liftFloorDisplayView.setTextureId("mitsubishi_nexway_screen_2_display");
                liftFloorDisplayView.setWidth(0.11875f);
                liftFloorDisplayView.setHeight(0.09375f);
                liftFloorDisplayView.setGravity(Gravity.CENTER_VERTICAL);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.CENTER);
                liftFloorDisplayView.setLetterSpacing(0);
                liftFloorDisplayView.setMargin(0.00125f, 0.0f, 0.0f, 0.0f);
                liftFloorDisplayView.addStoredMatrixTransformations(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, (double)-0.003125f));
                if (liftFloorDisplayView.getTextLength() >= 3) {
                    liftFloorDisplayView.setMargin(0.0f, 0.0f, 0.0f, 0.0f);
                    liftFloorDisplayView.setAdaptMode(TextView.AdaptMode.FORCE_FIT_WIDTH);
                } else {
                    liftFloorDisplayView.setAdaptMode(TextView.AdaptMode.ASPECT_FILL);
                }
                LiftArrowView liftArrowView = new LiftArrowView();
                liftArrowView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), LiftArrowView.ArrowType.AUTO);
                liftArrowView.setTexture(new Identifier("yte", "textures/block/mitsubishi_nexway_2_lcd_arrow_1.png"));
                liftArrowView.setDimension(0.09375f);
                liftArrowView.setGravity(Gravity.CENTER_VERTICAL);
                liftArrowView.setQueuedRenderLayer(QueuedRenderLayer.LIGHT_TRANSLUCENT);
                liftArrowView.setColor(-2);
                long time = WorldHelper.getTimeOfDay((World)world);
                Date day = new Date();
                long ticksInDay = time % 24000L;
                int totalSeconds = (int)((double)ticksInDay * 3.6);
                int hours = (totalSeconds / 3600 + 6) % 24;
                int minutes = totalSeconds % 3600 / 60;
                SimpleDateFormat dateFormat = new SimpleDateFormat("M\u6708 d\u65e5");
                String timeStr = dateFormat.format(day);
                String formattedTime = String.format("%02d:%02d", hours, minutes);
                String timePeriod = hours < 12 ? "AM" : "PM";
                String text = timeStr + " " + formattedTime + timePeriod;
                TextView textView = new TextView();
                textView.setId("textView");
                textView.setBasicsAttributes(world, blockPos, FontList.instance.getFont("wqy-microhei"), 5, -1);
                textView.setTextureId("schindler_z_line_3_keypad_1_display");
                textView.setText(text);
                textView.setWidth(0.25f);
                textView.setHeight(0.0625f);
                textView.setDisplayLength(20, 0.0f);
                textView.setTextAlign(TextView.HorizontalTextAlign.CENTER);
                textView.setGravity(Gravity.CENTER_HORIZONTAL);
                numberLayout.addChild(liftArrowView);
                numberLayout.addChild(liftFloorDisplayView);
                parentLayout.addChild(numberLayout);
                parentLayout.addChild(textView);
            }
        }
        parentLayout.render();
    }
}

