/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.screen;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import org.jetbrains.annotations.NotNull;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import top.xfunny.mod.client.screen.base.BaseConfigScreen;
import top.xfunny.mod.client.screen.widget.ContentItem;
import top.xfunny.mod.client.screen.widget.CustomSignsManager;

public class SignSettingScreen
extends BaseConfigScreen {
    private String selectedSignId;
    private final ObjectArrayList<String> allSignIds = CustomSignsManager.getSignList();
    private final ButtonWidgetExtension[] chooseSignButton;
    private final Consumer<String> callback;

    public SignSettingScreen(BlockPos blockPos, String selectedSignId, Consumer<String> callback) {
        super(blockPos);
        this.selectedSignId = selectedSignId;
        this.callback = callback;
        CustomSignsManager.loader();
        this.chooseSignButton = new ButtonWidgetExtension[this.allSignIds.size()];
    }

    @Override
    protected void init2() {
        super.init2();
    }

    @Override
    public void render(@NotNull GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
    }

    @Override
    public void onClose2() {
        super.onClose2();
    }

    private void drawSignItems() {
        this.listViewWidget.addCategory(TextHelper.translatable((String)"gui.yte.built_in_style", (Object[])new Object[0]));
        for (int i = 0; i < this.allSignIds.size(); ++i) {
            String signId = (String)this.allSignIds.get(i);
            if (signId == null || signId.isEmpty()) continue;
            if (this.chooseSignButton[i] == null) {
                int index = i;
                this.chooseSignButton[i] = new ButtonWidgetExtension(0, 0, 60, 20, TextHelper.translatable((String)"gui.yte.select", (Object[])new Object[0]), button -> this.setSelectedSign((String)this.allSignIds.get(index)));
            }
            if (signId.equals(this.selectedSignId)) {
                this.chooseSignButton[i].setMessage2(Text.cast((HolderBase)TextHelper.translatable((String)"gui.yte.selected", (Object[])new Object[0])));
                this.chooseSignButton[i].f_93623_ = false;
            } else {
                this.chooseSignButton[i].setMessage2(Text.cast((HolderBase)TextHelper.translatable((String)"gui.yte.select", (Object[])new Object[0])));
                this.chooseSignButton[i].f_93623_ = true;
            }
            Identifier SIGN_ICON = new Identifier("mtr:textures/block/sign/" + signId + ".png");
            String displaySignId = signId.replace("_", " ");
            if (i == CustomSignsManager.getDefaultSignListSize()) {
                this.listViewWidget.addCategory(TextHelper.translatable((String)"gui.yte.extended_style", (Object[])new Object[0]));
            }
            this.addChild(new ClickableWidget((AbstractWidget)this.chooseSignButton[i]));
            ContentItem chooseSignItem = new ContentItem(TextHelper.translatable((String)displaySignId, (Object[])new Object[0]), this.chooseSignButton[i]);
            chooseSignItem.setIcon(SIGN_ICON);
            this.listViewWidget.add(chooseSignItem);
        }
    }

    @Override
    public MutableText getScreenTitle() {
        return TextHelper.translatable((String)"gui.yte.signs.list.signs_setting", (Object[])new Object[0]);
    }

    @Override
    public MutableText getScreenSubtitle() {
        return TextHelper.translatable((String)"gui.yte.signs.subtitle", (Object[])new Object[]{this.selectedSignId});
    }

    @Override
    public void addItemConfig() {
        this.drawSignItems();
        this.listViewWidget.addCategory(TextHelper.translatable((String)"\u66f4\u591a\u8bbe\u7f6e", (Object[])new Object[0]));
    }

    public void setSelectedSign(String signId) {
        this.callback.accept(signId);
        this.selectedSignId = signId;
        for (int i = 0; i < this.allSignIds.size(); ++i) {
            if (((String)this.allSignIds.get(i)).equals(this.selectedSignId)) {
                this.chooseSignButton[i].setMessage2(Text.cast((HolderBase)TextHelper.translatable((String)"gui.yte.selected", (Object[])new Object[0])));
                this.chooseSignButton[i].f_93623_ = false;
                continue;
            }
            this.chooseSignButton[i].setMessage2(Text.cast((HolderBase)TextHelper.translatable((String)"gui.yte.select", (Object[])new Object[0])));
            this.chooseSignButton[i].f_93623_ = true;
        }
    }
}

