/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.screen.widget;

import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import top.xfunny.mod.client.screen.GuiHelper;
import top.xfunny.mod.client.screen.widget.BaseListItem;

public class ContentItem
extends BaseListItem {
    public final MutableText title;
    public final ButtonWidgetExtension widget;
    private Identifier textureResource;
    private boolean hasIcon;
    private double hoverOpacity = 0.0;

    public ContentItem(MutableText title, ButtonWidgetExtension widget, int height) {
        super(height);
        this.title = title;
        this.widget = widget;
    }

    public ContentItem(MutableText title, ButtonWidgetExtension widget) {
        this(title, widget, 26);
    }

    public void setIcon(Identifier textureResource) {
        if (textureResource != null) {
            this.textureResource = textureResource;
            this.hasIcon = true;
        } else {
            this.hasIcon = false;
        }
    }

    public boolean hasIcon() {
        return this.hasIcon;
    }

    @Override
    public void positionChanged(int entryX, int entryY) {
        if (this.widget != null) {
            int offsetY = (this.height - this.widget.getHeight2()) / 2;
            this.widget.setX2(entryX - this.widget.getWidth2());
            this.widget.setY2(entryY + offsetY);
        }
    }

    @Override
    public void draw(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, int entryX, int entryY, int width, int height, int mouseX, int mouseY, boolean widgetVisible, float tickDelta) {
        super.draw(graphicsHolder, guiDrawing, entryX, entryY, width, height, mouseX, mouseY, widgetVisible, tickDelta);
        this.drawBackground(guiDrawing, entryX, entryY, width, mouseX, mouseY, tickDelta);
        this.drawListEntry(graphicsHolder, entryX, entryY, mouseX, mouseY, widgetVisible, tickDelta);
    }

    private void drawListEntry(GraphicsHolder graphicsHolder, int entryX, int entryY, int mouseX, int mouseY, boolean widgetVisible, float tickDelta) {
        if (this.title != null) {
            this.drawListEntryDescription(graphicsHolder, entryX, entryY);
        }
        if (this.widget != null) {
            this.widget.f_93624_ = widgetVisible;
            this.widget.render(graphicsHolder, mouseX, mouseY, tickDelta);
        }
    }

    private void drawListEntryDescription(GraphicsHolder graphicsHolder, int entryX, int entryY) {
        int textHeight = 9;
        int iconSize = this.hasIcon() ? this.height - 5 : 0;
        int textY = this.height / 2 - textHeight / 2 - 2;
        graphicsHolder.push();
        graphicsHolder.translate((double)entryX, (double)entryY, 0.0);
        graphicsHolder.translate(5.0, 2.5, 0.0);
        if (this.hasIcon()) {
            GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
            guiDrawing.beginDrawingTexture(this.textureResource);
            guiDrawing.drawTexture(0.0, 0.0, (double)iconSize, (double)iconSize, 0.0f, 0.0f, 1.0f, 1.0f);
            guiDrawing.finishDrawingTexture();
            graphicsHolder.translate((double)(iconSize + 5), 0.0, 0.0);
        }
        graphicsHolder.drawText(this.title, 0, textY, -1, true, GraphicsHolder.getDefaultLight());
        graphicsHolder.pop();
    }

    private void drawBackground(GuiDrawing guiDrawing, int entryX, int entryY, int width, int mouseX, int mouseY, float tickDelta) {
        double highlightFadeSpeed = tickDelta / 4.0f;
        boolean entryHovered = mouseX >= entryX && mouseY >= entryY && mouseX < entryX + width && mouseY < entryY + this.height;
        double d = this.hoverOpacity = entryHovered ? Math.min(1.0, this.hoverOpacity + highlightFadeSpeed) : Math.max(0.0, this.hoverOpacity - highlightFadeSpeed);
        if (this.hoverOpacity > 0.0) {
            this.drawListEntryHighlight(guiDrawing, entryX, entryY, width, this.height);
        }
    }

    private void drawListEntryHighlight(GuiDrawing guiDrawing, int x, int y, int width, int height) {
        int highlightAlpha = (int)(100.0 * this.hoverOpacity);
        int highlightColor = highlightAlpha << 24 | 0x960000 | 0x9600 | 0x96;
        GuiHelper.drawRectangle(guiDrawing, x, y, width, height, highlightColor);
    }
}

