/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.RenderView;

public class ImageView
implements RenderView {
    public float y;
    protected String id;
    protected float width;
    protected float height;
    protected float x;
    protected World world;
    protected BlockPos blockPos;
    protected int color = -1;
    private StoredMatrixTransformations storedMatrixTransformations;
    private float marginLeft;
    private float marginTop;
    private float marginRight;
    private float marginBottom;
    private Gravity gravity;
    private Identifier texture;
    private float scale;
    private int light = GraphicsHolder.getDefaultLight();
    private float[] uv;
    private QueuedRenderLayer queuedRenderLayer = QueuedRenderLayer.EXTERIOR;
    private boolean needBlink;
    private float blinkInterval = 0.5f;

    public ImageView() {
        this.uv = new float[]{1.0f, 1.0f, 0.0f, 0.0f};
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTexture(Identifier texture) {
        this.texture = texture;
    }

    public void setDimension(float width, float rawWidth, float rawHeight) {
        float scale = rawHeight / rawWidth;
        this.setWidth(width);
        this.scale = scale;
        this.calculateDimensions();
    }

    public void setDimension(float width, float scale) {
        this.setWidth(width);
        this.scale = scale;
        this.calculateDimensions();
    }

    public void setDimension(float width) {
        this.setWidth(width);
        this.scale = 1.0f;
        this.calculateDimensions();
    }

    public void setLight(int light) {
        this.light = light;
    }

    public void setQueuedRenderLayer(QueuedRenderLayer queuedRenderLayer) {
        this.queuedRenderLayer = queuedRenderLayer;
    }

    public void setBasicsAttributes(World world, BlockPos blockPos) {
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public void render() {
        float gameTick = InitClient.getGameTick();
        BlockState blockState = this.world.getBlockState(this.blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)DirectionHelper.FACING);
        StoredMatrixTransformations storedMatrixTransformations1 = this.storedMatrixTransformations.copy();
        boolean shouldRender = true;
        if (this.needBlink && this.blinkInterval > 0.0f) {
            int framesPerCycle = (int)(this.blinkInterval * 20.0f);
            int currentFrame = (int)(gameTick % (float)framesPerCycle);
            boolean bl = shouldRender = currentFrame < framesPerCycle / 2;
        }
        if (shouldRender) {
            MainRenderer.scheduleRender((Identifier)this.texture, (boolean)false, (QueuedRenderLayer)this.queuedRenderLayer, (graphicsHolder, offset) -> {
                storedMatrixTransformations1.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)this.uv[0], (float)this.uv[1], (float)this.uv[2], (float)this.uv[3], (Direction)facing, (int)this.color, (int)this.light);
                graphicsHolder.pop();
            });
        }
    }

    public void calculateDimensions() {
        this.height = this.width * this.scale;
    }

    @Override
    public void setStoredMatrixTransformations(StoredMatrixTransformations storedMatrixTransformations) {
        this.storedMatrixTransformations = storedMatrixTransformations;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    @Override
    public float[] getMargin() {
        return new float[]{this.marginLeft, this.marginTop, this.marginRight, this.marginBottom};
    }

    @Override
    public Gravity getGravity() {
        return this.gravity;
    }

    @Override
    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Override
    public void setMargin(float left, float top, float right, float bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
    }

    protected void setUv(float[] uv) {
        this.uv = uv;
    }

    public void setFlip(boolean flipVertical, boolean flipHorizontal) {
        if (flipVertical) {
            float tempV = this.uv[0];
            this.uv[0] = this.uv[2];
            this.uv[2] = tempV;
        }
        if (flipHorizontal) {
            float tempU = this.uv[1];
            this.uv[1] = this.uv[3];
            this.uv[3] = tempU;
        }
    }

    public void setAnimationBliking(boolean needBlink, float blinkInterval) {
        this.needBlink = needBlink;
        this.blinkInterval = blinkInterval;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setParentDimensions(float parentWidth, float parentHeight) {
    }

    @Override
    public void calculateLayoutWidth() {
    }

    @Override
    public void calculateLayoutHeight() {
    }

    @Override
    public float[] calculateChildGravityOffset(float childWidth, float childHeight, float[] childMargin, Gravity childGravity) {
        return new float[0];
    }

    @Override
    public Object getParentType() {
        return null;
    }

    @Override
    public void setParentType(Object thisObject) {
    }
}

