/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view;

import java.awt.Font;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.World;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.util.ClientGetLiftDetails;

public class LiftFloorDisplayView
extends TextView {
    private Lift lift;
    private boolean noFloorNumber;
    private boolean noFloorDisplay;

    @Override
    public void render() {
        this.formatFloorText();
        if (!this.noFloorNumber || !this.noFloorDisplay) {
            super.render();
        }
    }

    private void formatFloorText() {
        ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(this.world, this.lift, Init.positionToBlockPos((Position)this.lift.getCurrentFloor().getPosition()));
        String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
        String floorDescription = (String)((ObjectObjectImmutablePair)liftDetails.right()).right();
        this.noFloorNumber = floorNumber.isEmpty();
        this.noFloorDisplay = floorDescription.isEmpty();
        this.gameTick = InitClient.getGameTick();
        if (!this.noFloorNumber || !this.noFloorDisplay) {
            this.text = String.format("%s%s", floorNumber, this.noFloorNumber ? " " : "");
        }
    }

    public void setBasicsAttributes(World world, BlockPos blockPos, Lift lift, Font font, float fontSize, int color) {
        this.world = world;
        this.blockPos = blockPos;
        this.lift = lift;
        this.font = font;
        this.fontSize = fontSize;
        this.color = color;
    }

    @Override
    public int getTextLength() {
        this.formatFloorText();
        return this.text.length();
    }
}

