/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view.view_group;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Consumer;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.RenderView;

public class FrameLayout
implements RenderView {
    private final ObjectArrayList<RenderView> children = new ObjectArrayList();
    private String id;
    private StoredMatrixTransformations storedMatrixTransformations;
    private float marginLeft;
    private float marginTop;
    private float marginRight;
    private float marginBottom;
    private float x;
    private float y;
    private float parentWidth;
    private float parentHeight;
    private float width;
    private float height;
    private Gravity gravity;
    private LayoutSize widthType;
    private LayoutSize heightType;
    private Object parentType;
    private float coordinateOriginX;
    private float coordinateOriginY;
    private int backgroundColor;
    private World world;
    private BlockPos blockPos;
    private Consumer<GraphicsHolder> transformation;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void render() {
        this.calculateLayoutWidth();
        this.calculateLayoutHeight();
        this.calculateSelfCoordinateOrigin();
        if (this.transformation != null) {
            this.storedMatrixTransformations.add(this.transformation);
        }
        if (this.backgroundColor != 0) {
            StoredMatrixTransformations storedMatrixTransformations1 = this.storedMatrixTransformations.copy();
            storedMatrixTransformations1.add(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, (double)-0.003125f));
            MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/white.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations1.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)this.backgroundColor, (int)15);
                graphicsHolder.pop();
            });
        }
        StoredMatrixTransformations storedMatrixTransformations2 = this.storedMatrixTransformations.copy();
        storedMatrixTransformations2.add(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, (double)((float)(this.backgroundColor != 0 ? 2 : 0) * -0.003125f)));
        for (RenderView child : this.children) {
            float[] margin = child.getMargin();
            Gravity childGravity = child.getGravity();
            child.setParentType(this);
            child.setStoredMatrixTransformations(storedMatrixTransformations2);
            child.setParentDimensions(this.width, this.height);
            child.calculateLayoutWidth();
            child.calculateLayoutHeight();
            float[] childGravityPositionOffset = this.calculateChildGravityOffset(child.getWidth(), child.getHeight(), margin, childGravity);
            child.setPosition(this.coordinateOriginX + childGravityPositionOffset[0], this.coordinateOriginY + this.height - margin[1] - child.getHeight() + childGravityPositionOffset[1]);
            child.render();
            storedMatrixTransformations2.add(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, (double)-7.8125E-4f));
        }
    }

    public void addChild(RenderView child) {
        this.children.add((Object)child);
    }

    @Override
    public void setStoredMatrixTransformations(StoredMatrixTransformations storedMatrixTransformations) {
        this.storedMatrixTransformations = storedMatrixTransformations;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(LayoutSize widthType) {
        this.widthType = widthType;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(LayoutSize heightType) {
        this.heightType = heightType;
    }

    @Override
    public float[] getMargin() {
        return new float[]{this.marginLeft, this.marginTop, this.marginRight, this.marginBottom};
    }

    @Override
    public Gravity getGravity() {
        return this.gravity;
    }

    @Override
    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Override
    public void setMargin(float left, float top, float right, float bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setParentDimensions(float parentWidth, float parentHeight) {
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
    }

    @Override
    public void calculateLayoutWidth() {
        switch (this.widthType) {
            case WRAP_CONTENT: {
                float maxWidth = 0.0f;
                for (RenderView child : this.children) {
                    float[] margin = child.getMargin();
                    child.calculateLayoutWidth();
                    maxWidth = Math.max(maxWidth, child.getWidth() + margin[0] + margin[2]);
                }
                this.width = maxWidth;
                break;
            }
            case MATCH_PARENT: {
                this.width = this.parentWidth;
                break;
            }
            default: {
                this.width = this.widthType.ordinal();
            }
        }
    }

    @Override
    public void calculateLayoutHeight() {
        switch (this.heightType) {
            case WRAP_CONTENT: {
                float maxHeight = 0.0f;
                for (RenderView child : this.children) {
                    float[] margin = child.getMargin();
                    child.calculateLayoutHeight();
                    maxHeight = Math.max(maxHeight, child.getHeight() + margin[1] + margin[3]);
                }
                this.height = maxHeight;
                break;
            }
            case MATCH_PARENT: {
                this.height = this.parentHeight;
                break;
            }
            default: {
                this.height = this.heightType.ordinal();
            }
        }
    }

    @Override
    public float[] calculateChildGravityOffset(float childWidth, float childHeight, float[] childMargin, Gravity childGravity) {
        float[] offset = new float[2];
        if (childGravity == null) {
            offset = new float[]{this.width / 2.0f - childWidth - childMargin[0], this.height - childHeight - childMargin[2]};
        } else {
            switch (childGravity) {
                case START: {
                    offset = new float[]{this.width / 2.0f - childWidth - childMargin[0], 0.0f};
                    break;
                }
                case CENTER_VERTICAL: {
                    offset = new float[]{0.0f, -(this.height - childHeight) / 2.0f};
                    break;
                }
                case CENTER_HORIZONTAL: {
                    offset = new float[]{-childWidth / 2.0f, 0.0f};
                    break;
                }
                case CENTER: {
                    offset = new float[]{-childWidth / 2.0f, -(this.height - childHeight) / 2.0f};
                    break;
                }
                case END: {
                    offset = new float[]{-this.width / 2.0f + childMargin[2], 0.0f};
                    break;
                }
                case TOP: {
                    offset = new float[]{0.0f, -this.height / 2.0f + childMargin[1]};
                    break;
                }
                case BOTTOM: {
                    offset = new float[]{0.0f, this.height};
                }
            }
        }
        return offset;
    }

    @Override
    public Object getParentType() {
        return this.parentType;
    }

    @Override
    public void setParentType(Object thisObject) {
        this.parentType = thisObject;
    }

    public ObjectArrayList<RenderView> getChildren() {
        return this.children;
    }

    private void calculateSelfCoordinateOrigin() {
        this.coordinateOriginX = this.x + this.width / 2.0f;
        this.coordinateOriginY = this.y;
    }

    public void addStoredMatrixTransformations(Consumer<GraphicsHolder> transformation) {
        this.transformation = transformation;
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
    }

    public void setBasicsAttributes(World world, BlockPos blockPos) {
        this.world = world;
        this.blockPos = blockPos;
    }
}

