/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.item;

import javax.annotation.Nonnull;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockLiftTrackBase;
import org.mtr.mod.block.BlockLiftTrackFloor;
import top.xfunny.mod.item.PathFinder;

public class FloorAutoSetter
extends ItemExtension
implements DirectionHelper {
    public FloorAutoSetter(ItemSettings itemSettings) {
        super(itemSettings.maxCount(1));
    }

    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        if (!context.getWorld().isClient()) {
            if (this.clickCondition(context)) {
                CompoundTag compoundTag = context.getStack().getOrCreateTag();
                compoundTag.putLong("pos", context.getBlockPos().asLong());
                this.onClick(context, compoundTag);
                return ActionResult.SUCCESS;
            }
            return ActionResult.FAIL;
        }
        return super.useOnBlock2(context);
    }

    protected void onClick(ItemUsageContext context, CompoundTag compoundTag) {
        PathFinder pathFinder = new PathFinder();
        PlayerEntity playerEntity = context.getPlayer();
        World world = context.getWorld();
        BlockPos pos = context.getBlockPos();
        int number = 0;
        int floorCount = 0;
        int floorNumber = 0;
        boolean ding = false;
        String floorNumber2 = "";
        BlockEntity floorEntity = world.getBlockEntity(pos);
        if (floorEntity != null && floorEntity.data instanceof BlockLiftTrackFloor.BlockEntity) {
            String checkFloorNumber = ((BlockLiftTrackFloor.BlockEntity)floorEntity.data).getFloorNumber();
            floorNumber2 = checkFloorNumber != null ? ((BlockLiftTrackFloor.BlockEntity)floorEntity.data).getFloorNumber() : "1";
            ding = ((BlockLiftTrackFloor.BlockEntity)floorEntity.data).getShouldDing();
        }
        if (floorNumber2.matches("\\d+")) {
            floorNumber = Integer.parseInt(floorNumber2);
        }
        while (floorNumber2.matches("\\d+")) {
            if (world.getBlockState((BlockPos)pos).getBlock().data instanceof BlockLiftTrackBase) {
                BlockEntity floorEntity1 = world.getBlockEntity(pos);
                if (floorEntity1 != null && floorEntity1.data instanceof BlockLiftTrackFloor.BlockEntity) {
                    ((BlockLiftTrackFloor.BlockEntity)floorEntity1.data).setData(String.valueOf(floorNumber), "", ding);
                }
                Object[] apos = pathFinder.findPath(context, pos);
                pos = (BlockPos)apos[0];
                if (world.getBlockState((BlockPos)pos).getBlock().data instanceof BlockLiftTrackFloor) {
                    ++floorCount;
                }
            } else {
                if (playerEntity == null) break;
                playerEntity.sendMessage(Text.cast((HolderBase)TextHelper.translatable((String)"message.floor_auto_setter_status_failed", (Object[])new Object[0])), true);
                break;
            }
            if (number == pathFinder.getMark().size()) {
                if (playerEntity == null) break;
                playerEntity.sendMessage(Text.cast((HolderBase)TextHelper.translatable((String)"message.floor_auto_setter_status_finished", (Object[])new Object[]{floorCount})), true);
                break;
            }
            ++number;
            if (!(world.getBlockState((BlockPos)pos.up((int)1)).getBlock().data instanceof BlockLiftTrackFloor)) continue;
            ++floorNumber;
        }
    }

    protected boolean clickCondition(ItemUsageContext context) {
        Block block = context.getWorld().getBlockState(context.getBlockPos()).getBlock();
        return block.data instanceof BlockLiftTrackFloor;
    }
}

