/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import top.xfunny.mod.block.SchindlerZLine3Keypad1;

public class IDCard
extends ItemExtension {
    public static final String FLOOR_TAG = "floor";
    public static final String ACCESS_TAG = "access_level";

    public IDCard(ItemSettings itemSettings) {
        super(itemSettings.maxCount(1));
    }

    public static void setFloor(ItemStack stack, int floor) {
        stack.getOrCreateTag().putInt(FLOOR_TAG, floor);
    }

    public static void setAccessLevel(ItemStack stack, int level) {
        stack.getOrCreateTag().putInt(ACCESS_TAG, level);
    }

    public static int getFloor(ItemStack stack) {
        return stack.getOrCreateTag().getInt(FLOOR_TAG);
    }

    public static int getAccessLevel(ItemStack stack) {
        return stack.getOrCreateTag().getInt(ACCESS_TAG);
    }

    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        if (!context.getWorld().isClient()) {
            if (this.isValidBlock(context)) {
                PlayerEntity player;
                CompoundTag tag = context.getStack().getOrCreateTag();
                if (!tag.contains(FLOOR_TAG)) {
                    tag.putInt(FLOOR_TAG, 1);
                }
                if (!tag.contains(ACCESS_TAG)) {
                    tag.putInt(ACCESS_TAG, 1);
                }
                if ((player = context.getPlayer()) != null) {
                    player.sendMessage(Text.cast((HolderBase)TextHelper.translatable((String)"message.id_card.current_status", (Object[])new Object[]{tag.getInt(FLOOR_TAG), tag.getInt(ACCESS_TAG)})), true);
                }
                return ActionResult.SUCCESS;
            }
            return ActionResult.FAIL;
        }
        return super.useOnBlock2(context);
    }

    public void addTooltips(ItemStack stack, @Nullable World world, List<MutableText> tooltip, TooltipContext options) {
        CompoundTag tag = stack.getOrCreateTag();
        int floor = tag.contains(FLOOR_TAG) ? tag.getInt(FLOOR_TAG) : 0;
        int accessLevel = tag.contains(ACCESS_TAG) ? tag.getInt(ACCESS_TAG) : 1;
        tooltip.add(TextHelper.translatable((String)"tooltip.id_card.access", (Object[])new Object[]{floor}).formatted(TextFormatting.GRAY));
        tooltip.add(TextHelper.translatable((String)"tooltip.id_card.floors", (Object[])new Object[]{accessLevel}).formatted(TextFormatting.GRAY));
    }

    private boolean isValidBlock(ItemUsageContext context) {
        Block block = context.getWorld().getBlockState(context.getBlockPos()).getBlock();
        return block.data instanceof SchindlerZLine3Keypad1;
    }
}

