/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.packet;

import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockRailwaySign;
import org.mtr.mod.block.BlockRouteSignBase;

public final class PacketUpdatePATRS01RailwaySignConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final LongAVLTreeSet selectedIds;
    private final String[] signIds;

    public PacketUpdatePATRS01RailwaySignConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        int selectedIdsLength = packetBufferReceiver.readInt();
        this.selectedIds = new LongAVLTreeSet();
        for (int i = 0; i < selectedIdsLength; ++i) {
            this.selectedIds.add(packetBufferReceiver.readLong());
        }
        int signLength = packetBufferReceiver.readInt();
        this.signIds = new String[signLength];
        for (int i = 0; i < signLength; ++i) {
            String signId = packetBufferReceiver.readString();
            this.signIds[i] = signId.isEmpty() ? null : signId;
        }
    }

    public PacketUpdatePATRS01RailwaySignConfig(BlockPos blockPos, LongAVLTreeSet selectedIds, String[] signIds) {
        this.blockPos = blockPos;
        this.selectedIds = selectedIds;
        this.signIds = signIds;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.selectedIds.size());
        this.selectedIds.forEach(arg_0 -> ((PacketBufferSender)packetBufferSender).writeLong(arg_0));
        packetBufferSender.writeInt(this.signIds.length);
        for (String signType : this.signIds) {
            packetBufferSender.writeString(signType == null ? "" : signType);
        }
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        if (!Init.isChunkLoaded((World)serverPlayerEntity.getEntityWorld(), (BlockPos)this.blockPos)) {
            return;
        }
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null) {
            if (entity.data instanceof BlockRailwaySign.BlockEntity) {
                ((BlockRailwaySign.BlockEntity)entity.data).setData(this.selectedIds, this.signIds);
            } else if (entity.data instanceof BlockRouteSignBase.BlockEntityBase) {
                long platformId = this.selectedIds.isEmpty() ? 0L : (Long)this.selectedIds.toArray()[0];
                ((BlockRouteSignBase.BlockEntityBase)entity.data).setPlatformId(platformId);
                BlockEntity entityAbove = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos.up());
                if (entityAbove != null && entityAbove.data instanceof BlockRouteSignBase.BlockEntityBase) {
                    ((BlockRouteSignBase.BlockEntityBase)entityAbove.data).setPlatformId(platformId);
                }
            }
        }
    }
}

