/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.armor_hud.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ArmorHudConfig {
    private static volatile ArmorHudConfig INSTANCE;
    private static final Gson GSON;
    private static final Path CONFIG_PATH;
    private int xOffset;
    private int yOffset;
    private int xOffsetLeft1;
    private int yOffsetLeft1;
    private int xOffsetLeft2;
    private int yOffsetLeft2;
    private int xOffsetRight;
    private int yOffsetRight;
    private boolean splitMode = false;
    private boolean vertical = false;
    private float durabilityWarningThreshold;
    private int boxSize;
    private int spacing;
    private boolean visible;
    private int durabilityDisplayMode = 0;
    private boolean darkMode;
    private boolean showBoxTexture = true;
    private String language = "auto";
    private int lastGuiScaleChecked = -1;
    private int numberOffsetX = 0;
    private int numberOffsetY = 0;
    private int numberOffsetXLeft = 0;
    private int numberOffsetYLeft = 0;
    private int numberOffsetXRight = 0;
    private int numberOffsetYRight = 0;
    public static final int DEFAULT_X_OFFSET_LEFT1_1 = -950;
    public static final int DEFAULT_Y_OFFSET_LEFT1_1 = -102;
    public static final int DEFAULT_X_OFFSET_LEFT2_1 = -950;
    public static final int DEFAULT_Y_OFFSET_LEFT2_1 = -52;
    public static final int DEFAULT_X_OFFSET_RIGHT_1 = 930;
    public static final int DEFAULT_Y_OFFSET_RIGHT_1 = -52;
    public static final int DEFAULT_X_OFFSET_LEFT1_2 = -470;
    public static final int DEFAULT_Y_OFFSET_LEFT1_2 = -102;
    public static final int DEFAULT_X_OFFSET_LEFT2_2 = -470;
    public static final int DEFAULT_Y_OFFSET_LEFT2_2 = -52;
    public static final int DEFAULT_X_OFFSET_RIGHT_2 = 450;
    public static final int DEFAULT_Y_OFFSET_RIGHT_2 = -52;
    public static final int DEFAULT_X_OFFSET_LEFT1_3 = -310;
    public static final int DEFAULT_Y_OFFSET_LEFT1_3 = -102;
    public static final int DEFAULT_X_OFFSET_LEFT2_3 = -310;
    public static final int DEFAULT_Y_OFFSET_LEFT2_3 = -52;
    public static final int DEFAULT_X_OFFSET_RIGHT_3 = 290;
    public static final int DEFAULT_Y_OFFSET_RIGHT_3 = -52;
    public static final int DEFAULT_X_OFFSET_LEFT1_4 = -230;
    public static final int DEFAULT_Y_OFFSET_LEFT1_4 = -102;
    public static final int DEFAULT_X_OFFSET_LEFT2_4 = -230;
    public static final int DEFAULT_Y_OFFSET_LEFT2_4 = -52;
    public static final int DEFAULT_X_OFFSET_RIGHT_4 = -210;
    public static final int DEFAULT_Y_OFFSET_RIGHT_4 = -52;
    public static final int DEFAULT_X_OFFSET_NORM_HOR = -220;
    public static final int DEFAULT_Y_OFFSET_NORM_HOR = -22;
    public static final int DEFAULT_X_OFFSET_LEFT2_HOR = -180;
    public static final int DEFAULT_Y_OFFSET_LEFT2_HOR = -22;
    public static final int DEFAULT_X_OFFSET_RIGHT_HOR = 100;
    public static final int DEFAULT_Y_OFFSET_RIGHT_HOR = -22;
    public static final int DEFAULT_BOX_SIZE = 22;
    public static final int DEFAULT_SPACING = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArmorHudConfig getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ArmorHudConfig> clazz = ArmorHudConfig.class;
        synchronized (ArmorHudConfig.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = ArmorHudConfig.loadOrCreate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static ArmorHudConfig loadOrCreate() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (ArmorHudConfig)GSON.fromJson(json, ArmorHudConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
            }
        }
        return ArmorHudConfig.createDefaultConfig();
    }

    private static ArmorHudConfig createDefaultConfig() {
        ArmorHudConfig config = new ArmorHudConfig();
        config.boxSize = 22;
        config.spacing = 2;
        config.durabilityWarningThreshold = 0.2f;
        config.visible = true;
        config.durabilityDisplayMode = 0;
        config.darkMode = false;
        config.showBoxTexture = true;
        config.language = "auto";
        config.splitMode = false;
        config.vertical = false;
        config.xOffset = -220;
        config.yOffset = -22;
        config.xOffsetLeft1 = -950;
        config.yOffsetLeft1 = -102;
        config.xOffsetLeft2 = -950;
        config.yOffsetLeft2 = -52;
        config.xOffsetRight = 930;
        config.yOffsetRight = -52;
        config.lastGuiScaleChecked = -1;
        config.numberOffsetX = 0;
        config.numberOffsetY = 0;
        config.numberOffsetXLeft = 0;
        config.numberOffsetYLeft = 0;
        config.numberOffsetXRight = 0;
        config.numberOffsetYRight = 0;
        config.saveConfig();
        return config;
    }

    public void saveConfig() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public int getCurrentGuiScale() {
        try {
            return (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        }
        catch (Exception e) {
            return 2;
        }
    }

    public int getLastGuiScaleChecked() {
        return this.lastGuiScaleChecked;
    }

    public void setLastGuiScaleChecked(int value) {
        this.lastGuiScaleChecked = value;
        this.saveConfig();
    }

    public void applyCurrentModeDefaults() {
        int guiScale = this.getCurrentGuiScale();
        if (this.vertical) {
            this.setDefaultsForStackedMode(guiScale, this.splitMode);
        } else if (this.splitMode) {
            this.setDefaultsForSplitModeHorizontal();
        } else {
            this.setDefaultsForHorizontalMode();
        }
        this.saveConfig();
    }

    public void setDefaultsForStackedMode(int guiScale, boolean splitMode) {
        if (splitMode) {
            switch (guiScale) {
                case 1: {
                    this.xOffsetLeft2 = -950;
                    this.yOffsetLeft2 = -52;
                    this.xOffsetRight = 930;
                    this.yOffsetRight = -52;
                    break;
                }
                case 2: {
                    this.xOffsetLeft2 = -470;
                    this.yOffsetLeft2 = -52;
                    this.xOffsetRight = 450;
                    this.yOffsetRight = -52;
                    break;
                }
                case 3: {
                    this.xOffsetLeft2 = -310;
                    this.yOffsetLeft2 = -52;
                    this.xOffsetRight = 290;
                    this.yOffsetRight = -52;
                    break;
                }
                case 4: {
                    this.xOffsetLeft2 = -230;
                    this.yOffsetLeft2 = -52;
                    this.xOffsetRight = -210;
                    this.yOffsetRight = -52;
                    break;
                }
                default: {
                    this.xOffsetLeft2 = -115;
                    this.yOffsetLeft2 = -26;
                    this.xOffsetRight = -105;
                    this.yOffsetRight = -26;
                    break;
                }
            }
        } else {
            switch (guiScale) {
                case 1: {
                    this.xOffsetLeft1 = -950;
                    this.yOffsetLeft1 = -102;
                    break;
                }
                case 2: {
                    this.xOffsetLeft1 = -470;
                    this.yOffsetLeft1 = -102;
                    break;
                }
                case 3: {
                    this.xOffsetLeft1 = -310;
                    this.yOffsetLeft1 = -102;
                    break;
                }
                case 4: {
                    this.xOffsetLeft1 = -230;
                    this.yOffsetLeft1 = -102;
                    break;
                }
                default: {
                    this.xOffsetLeft1 = -115;
                    this.yOffsetLeft1 = -51;
                }
            }
        }
    }

    public void setDefaultsForSplitModeHorizontal() {
        this.xOffsetLeft2 = -180;
        this.yOffsetLeft2 = -22;
        this.xOffsetRight = 100;
        this.yOffsetRight = -22;
    }

    public void setDefaultsForHorizontalMode() {
        this.xOffset = -220;
        this.yOffset = -22;
    }

    public void resetToDefaults() {
        this.visible = true;
        this.language = "en";
        this.durabilityDisplayMode = 0;
        this.darkMode = false;
        this.showBoxTexture = true;
        this.vertical = false;
        this.splitMode = false;
        this.boxSize = 22;
        this.spacing = 2;
        this.durabilityWarningThreshold = 0.2f;
        this.numberOffsetX = 0;
        this.numberOffsetY = 0;
        this.numberOffsetXLeft = 0;
        this.numberOffsetYLeft = 0;
        this.numberOffsetXRight = 0;
        this.numberOffsetYRight = 0;
        this.xOffset = -220;
        this.yOffset = -22;
        this.xOffsetLeft1 = -950;
        this.yOffsetLeft1 = -102;
        this.xOffsetLeft2 = -950;
        this.yOffsetLeft2 = -52;
        this.xOffsetRight = 930;
        this.yOffsetRight = -52;
        this.lastGuiScaleChecked = -1;
        this.saveConfig();
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
        this.saveConfig();
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
        this.saveConfig();
    }

    public int getXOffsetLeft1() {
        return this.xOffsetLeft1;
    }

    public void setXOffsetLeft1(int xOffsetLeft1) {
        this.xOffsetLeft1 = xOffsetLeft1;
        this.saveConfig();
    }

    public int getYOffsetLeft1() {
        return this.yOffsetLeft1;
    }

    public void setYOffsetLeft1(int yOffsetLeft1) {
        this.yOffsetLeft1 = yOffsetLeft1;
        this.saveConfig();
    }

    public int getXOffsetLeft2() {
        return this.xOffsetLeft2;
    }

    public void setXOffsetLeft2(int xOffsetLeft2) {
        this.xOffsetLeft2 = xOffsetLeft2;
        this.saveConfig();
    }

    public int getYOffsetLeft2() {
        return this.yOffsetLeft2;
    }

    public void setYOffsetLeft2(int yOffsetLeft2) {
        this.yOffsetLeft2 = yOffsetLeft2;
        this.saveConfig();
    }

    public int getXOffsetRight() {
        return this.xOffsetRight;
    }

    public void setXOffsetRight(int xOffsetRight) {
        this.xOffsetRight = xOffsetRight;
        this.saveConfig();
    }

    public int getYOffsetRight() {
        return this.yOffsetRight;
    }

    public void setYOffsetRight(int yOffsetRight) {
        this.yOffsetRight = yOffsetRight;
        this.saveConfig();
    }

    public boolean isSplitMode() {
        return this.splitMode;
    }

    public void setSplitMode(boolean splitMode) {
        this.splitMode = splitMode;
        this.applyCurrentModeDefaults();
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        boolean previousVertical = this.vertical;
        this.vertical = vertical;
        if (this.splitMode && !vertical && previousVertical) {
            this.setDefaultsForSplitModeHorizontal();
        } else {
            this.applyCurrentModeDefaults();
        }
        this.saveConfig();
    }

    public float getDurabilityWarningThreshold() {
        return this.durabilityWarningThreshold;
    }

    public void setDurabilityWarningThreshold(float threshold) {
        this.durabilityWarningThreshold = threshold;
        this.saveConfig();
    }

    public int getBoxSize() {
        return this.boxSize;
    }

    public void setBoxSize(int size) {
        this.boxSize = size;
        this.saveConfig();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.saveConfig();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.saveConfig();
    }

    public boolean isShowBoxTexture() {
        return this.showBoxTexture;
    }

    public void setShowBoxTexture(boolean showBoxTexture) {
        this.showBoxTexture = showBoxTexture;
        this.saveConfig();
    }

    public int getDurabilityDisplayMode() {
        return this.durabilityDisplayMode;
    }

    public void setDurabilityDisplayMode(int mode) {
        this.durabilityDisplayMode = mode;
        this.saveConfig();
    }

    public int getNumberOffsetX() {
        return this.numberOffsetX;
    }

    public void setNumberOffsetX(int offset) {
        this.numberOffsetX = offset;
        this.saveConfig();
    }

    public int getNumberOffsetY() {
        return this.numberOffsetY;
    }

    public void setNumberOffsetY(int offset) {
        this.numberOffsetY = offset;
        this.saveConfig();
    }

    public int getNumberOffsetXLeft() {
        return this.numberOffsetXLeft;
    }

    public void setNumberOffsetXLeft(int offset) {
        this.numberOffsetXLeft = offset;
        this.saveConfig();
    }

    public int getNumberOffsetYLeft() {
        return this.numberOffsetYLeft;
    }

    public void setNumberOffsetYLeft(int offset) {
        this.numberOffsetYLeft = offset;
        this.saveConfig();
    }

    public int getNumberOffsetXRight() {
        return this.numberOffsetXRight;
    }

    public void setNumberOffsetXRight(int offset) {
        this.numberOffsetXRight = offset;
        this.saveConfig();
    }

    public int getNumberOffsetYRight() {
        return this.numberOffsetYRight;
    }

    public void setNumberOffsetYRight(int offset) {
        this.numberOffsetYRight = offset;
        this.saveConfig();
    }

    public boolean isDarkMode() {
        return this.darkMode && this.showBoxTexture;
    }

    public void setDarkMode(boolean darkMode) {
        this.darkMode = darkMode;
        this.saveConfig();
    }

    public String getLanguage() {
        return this.language == null ? "auto" : this.language;
    }

    public void setLanguage(String lang) {
        this.language = lang == null ? "auto" : lang;
        this.saveConfig();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("armor_hud.json");
    }
}

