/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.armor_hud.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mcjunky33.armor_hud.client.config.ArmorHudConfig;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class ArmorHudOverlay {
    private final ArmorHudConfig config = ArmorHudConfig.getInstance();
    private static final class_2960 HOTBAR_TEXTURE = class_2960.method_60655((String)"armor_hud", (String)"textures/gui/hotbar_texture.png");
    private static final class_2960 HOTBAR_TEXTURE_DARK = class_2960.method_60655((String)"armor_hud", (String)"textures/gui/hotbar_texture_dark.png");
    private static final int[] ARMOR_ORDER = new int[]{39, 38, 37, 36};

    public void renderArmorUI(class_332 context) {
        class_310 client = class_310.method_1551();
        if (!this.config.isVisible() || client.field_1690.field_1842 || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_1799[] armorItems = new class_1799[4];
        for (int i = 0; i < 4; ++i) {
            armorItems[i] = client.field_1724.method_31548().method_5438(ARMOR_ORDER[i]);
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int boxSize = this.config.getBoxSize();
        int spacing = this.config.getSpacing();
        if (this.config.isVertical()) {
            if (this.config.isSplitMode()) {
                int xOffsetLeft2 = screenWidth / 2 + this.config.getXOffsetLeft2();
                int yOffsetLeft2 = screenHeight + this.config.getYOffsetLeft2();
                for (int i = 0; i < 2; ++i) {
                    if (armorItems[i].method_7960()) continue;
                    this.drawBoxAndArmor(context, armorItems[i], xOffsetLeft2, yOffsetLeft2, boxSize, spacing, i, true, this.config.getNumberOffsetXLeft(), this.config.getNumberOffsetYLeft());
                }
                int xOffsetRight = screenWidth / 2 + this.config.getXOffsetRight();
                int yOffsetRight = screenHeight + this.config.getYOffsetRight();
                for (int i = 2; i < 4; ++i) {
                    if (armorItems[i].method_7960()) continue;
                    this.drawBoxAndArmor(context, armorItems[i], xOffsetRight, yOffsetRight, boxSize, spacing, i - 2, true, this.config.getNumberOffsetXRight(), this.config.getNumberOffsetYRight());
                }
            } else {
                int xOffsetLeft1 = screenWidth / 2 + this.config.getXOffsetLeft1();
                int yOffsetLeft1 = screenHeight + this.config.getYOffsetLeft1();
                for (int i = 0; i < 4; ++i) {
                    if (armorItems[i].method_7960()) continue;
                    this.drawBoxAndArmor(context, armorItems[i], xOffsetLeft1, yOffsetLeft1, boxSize, spacing, i, true, this.config.getNumberOffsetXLeft(), this.config.getNumberOffsetYLeft());
                }
            }
        } else if (this.config.isSplitMode()) {
            int xOffsetLeft2 = screenWidth / 2 + this.config.getXOffsetLeft2();
            int yOffsetLeft2 = screenHeight + this.config.getYOffsetLeft2();
            for (int i = 0; i < 2; ++i) {
                if (armorItems[i].method_7960()) continue;
                this.drawBoxAndArmor(context, armorItems[i], xOffsetLeft2, yOffsetLeft2, boxSize, spacing, i, false, this.config.getNumberOffsetXLeft(), this.config.getNumberOffsetYLeft());
            }
            int xOffsetRight = screenWidth / 2 + this.config.getXOffsetRight();
            int yOffsetRight = screenHeight + this.config.getYOffsetRight();
            for (int i = 2; i < 4; ++i) {
                if (armorItems[i].method_7960()) continue;
                this.drawBoxAndArmor(context, armorItems[i], xOffsetRight, yOffsetRight, boxSize, spacing, i - 2, false, this.config.getNumberOffsetXRight(), this.config.getNumberOffsetYRight());
            }
        } else {
            int xOffset = screenWidth / 2 + this.config.getXOffset();
            int yOffset = screenHeight + this.config.getYOffset();
            for (int i = 0; i < 4; ++i) {
                if (armorItems[i].method_7960()) continue;
                this.drawBoxAndArmor(context, armorItems[i], xOffset, yOffset, boxSize, spacing, i, false, this.config.getNumberOffsetX(), this.config.getNumberOffsetY());
            }
        }
    }

    private void drawBoxAndArmor(class_332 context, class_1799 armorItem, int baseX, int baseY, int boxSize, int spacing, int idx, boolean vertical, int offsetXNumber, int offsetYNumber) {
        int boxX = baseX + (!vertical ? idx * (boxSize + spacing) : 0);
        int boxY = baseY + (vertical ? idx * (boxSize + spacing) : 0);
        if (this.config.isShowBoxTexture()) {
            class_2960 texture = this.config.isDarkMode() ? HOTBAR_TEXTURE_DARK : HOTBAR_TEXTURE;
            context.method_25290(texture, boxX, boxY, 0.0f, 0.0f, boxSize, boxSize, boxSize, boxSize);
        }
        int itemSize = 16;
        int itemX = boxX + Math.round((float)(boxSize - itemSize) / 2.0f);
        int itemY = boxY + Math.round((float)(boxSize - itemSize) / 2.0f);
        context.method_51427(armorItem, itemX, itemY);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        GL11.glDepthFunc((int)519);
        int mode = this.config.getDurabilityDisplayMode();
        if (mode == 0) {
            this.drawDurabilityBar(context, boxX, boxY + boxSize - 6, boxSize, armorItem);
        } else if (mode == 1) {
            this.drawDurabilityTextSimple(context, boxX, boxY, boxSize, armorItem, offsetXNumber, offsetYNumber, false);
        } else if (mode == 2) {
            this.drawDurabilityTextSimple(context, boxX, boxY, boxSize, armorItem, offsetXNumber, offsetYNumber, true);
        }
        GL11.glDepthFunc((int)515);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    public void drawDurabilityBar(class_332 context, int x, int y, int width, class_1799 item) {
        int maxDamage = item.method_7936();
        int damage = item.method_7919();
        if (maxDamage <= 0) {
            return;
        }
        int barWidth = 13;
        int barX = x + (width - barWidth) / 2 + 1;
        int barHeight = 2;
        float durabilityRatio = (float)(maxDamage - damage) / (float)maxDamage;
        int remainingWidth = Math.round(durabilityRatio * 13.0f);
        int barColor = this.convertHSVtoARGB(durabilityRatio / 3.0f * 360.0f, 1.0f, 1.0f);
        this.fill(context, barX, y, barX + barWidth, y + barHeight, -16777216);
        this.fill(context, barX, y, barX + remainingWidth, y + barHeight / 2, barColor);
    }

    public void drawDurabilityTextSimple(class_332 context, int boxX, int boxY, int boxSize, class_1799 item, int offsetXNumber, int offsetYNumber, boolean showAsPercent) {
        String durabilityText;
        int maxDamage = item.method_7936();
        int damage = item.method_7919();
        if (maxDamage <= 0) {
            return;
        }
        int durability = maxDamage - damage;
        float ratio = (float)durability / (float)maxDamage;
        String string = durabilityText = showAsPercent ? Math.round(ratio * 100.0f) + "%" : String.valueOf(durability);
        int color = ratio > 0.7f ? -16711936 : (ratio > 0.4f ? -256 : (ratio > 0.2f ? -23296 : (ratio > 0.05f ? -65536 : -16777216)));
        class_327 textRenderer = class_310.method_1551().field_1772;
        int textWidth = textRenderer.method_1727(durabilityText);
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int textX = boxX + (boxSize - textWidth) / 2 + offsetXNumber;
        int textY = boxY + boxSize - textHeight + offsetYNumber;
        context.method_25303(textRenderer, durabilityText, textX, textY, color);
    }

    private void fill(class_332 context, int x1, int y1, int x2, int y2, int color) {
        context.method_25294(x1, y1, x2, y2, color);
    }

    private int convertHSVtoARGB(float h, float s, float v) {
        h = (h % 360.0f + 360.0f) % 360.0f;
        float hh = h / 60.0f;
        int i = (int)hh % 6;
        float f = hh - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        int r = 0;
        int g = 0;
        int b = 0;
        switch (i) {
            case 0: {
                r = Math.round(v * 255.0f);
                g = Math.round(t * 255.0f);
                b = Math.round(p * 255.0f);
                break;
            }
            case 1: {
                r = Math.round(q * 255.0f);
                g = Math.round(v * 255.0f);
                b = Math.round(p * 255.0f);
                break;
            }
            case 2: {
                r = Math.round(p * 255.0f);
                g = Math.round(v * 255.0f);
                b = Math.round(t * 255.0f);
                break;
            }
            case 3: {
                r = Math.round(p * 255.0f);
                g = Math.round(q * 255.0f);
                b = Math.round(v * 255.0f);
                break;
            }
            case 4: {
                r = Math.round(t * 255.0f);
                g = Math.round(p * 255.0f);
                b = Math.round(v * 255.0f);
                break;
            }
            case 5: {
                r = Math.round(v * 255.0f);
                g = Math.round(p * 255.0f);
                b = Math.round(q * 255.0f);
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static void renderPreview(class_332 context, int screenWidth, int screenHeight, ArmorHudConfig config) {
        class_1799[] previewArmor = new class_1799[]{new class_1799((class_1935)class_1802.field_8805), new class_1799((class_1935)class_1802.field_8678), new class_1799((class_1935)class_1802.field_8570), new class_1799((class_1935)class_1802.field_8313)};
        for (int i = 0; i < previewArmor.length; ++i) {
            class_1799 item = previewArmor[i];
            int max = item.method_7936();
            item.method_7974(switch (i) {
                case 0 -> max * 9 / 10;
                case 1 -> max / 4;
                case 2 -> max * 3 / 4;
                case 3 -> max / 2;
                default -> 0;
            });
        }
        int boxSize = config.getBoxSize();
        int spacing = config.getSpacing();
        if (config.isVertical()) {
            if (config.isSplitMode()) {
                xOffsetLeft2 = screenWidth / 2 + config.getXOffsetLeft2();
                yOffsetLeft2 = screenHeight + config.getYOffsetLeft2();
                for (int i = 0; i < 2; ++i) {
                    if (previewArmor[i].method_7960()) continue;
                    new ArmorHudOverlay().drawBoxAndArmor(context, previewArmor[i], xOffsetLeft2, yOffsetLeft2, boxSize, spacing, i, true, config.getNumberOffsetXLeft(), config.getNumberOffsetYLeft());
                }
                int xOffsetRight = screenWidth / 2 + config.getXOffsetRight();
                int yOffsetRight = screenHeight + config.getYOffsetRight();
                for (int i = 2; i < 4; ++i) {
                    if (previewArmor[i].method_7960()) continue;
                    new ArmorHudOverlay().drawBoxAndArmor(context, previewArmor[i], xOffsetRight, yOffsetRight, boxSize, spacing, i - 2, true, config.getNumberOffsetXRight(), config.getNumberOffsetYRight());
                }
            } else {
                int xOffsetLeft1 = screenWidth / 2 + config.getXOffsetLeft1();
                int yOffsetLeft1 = screenHeight + config.getYOffsetLeft1();
                for (int i = 0; i < 4; ++i) {
                    if (previewArmor[i].method_7960()) continue;
                    new ArmorHudOverlay().drawBoxAndArmor(context, previewArmor[i], xOffsetLeft1, yOffsetLeft1, boxSize, spacing, i, true, config.getNumberOffsetXLeft(), config.getNumberOffsetYLeft());
                }
            }
        } else if (config.isSplitMode()) {
            xOffsetLeft2 = screenWidth / 2 + config.getXOffsetLeft2();
            yOffsetLeft2 = screenHeight + config.getYOffsetLeft2();
            for (int i = 0; i < 2; ++i) {
                if (previewArmor[i].method_7960()) continue;
                new ArmorHudOverlay().drawBoxAndArmor(context, previewArmor[i], xOffsetLeft2, yOffsetLeft2, boxSize, spacing, i, false, config.getNumberOffsetXLeft(), config.getNumberOffsetYLeft());
            }
            int xOffsetRight = screenWidth / 2 + config.getXOffsetRight();
            int yOffsetRight = screenHeight + config.getYOffsetRight();
            for (int i = 2; i < 4; ++i) {
                if (previewArmor[i].method_7960()) continue;
                new ArmorHudOverlay().drawBoxAndArmor(context, previewArmor[i], xOffsetRight, yOffsetRight, boxSize, spacing, i - 2, false, config.getNumberOffsetXRight(), config.getNumberOffsetYRight());
            }
        } else {
            int xOffset = screenWidth / 2 + config.getXOffset();
            int yOffset = screenHeight + config.getYOffset();
            for (int i = 0; i < 4; ++i) {
                if (previewArmor[i].method_7960()) continue;
                new ArmorHudOverlay().drawBoxAndArmor(context, previewArmor[i], xOffset, yOffset, boxSize, spacing, i, false, config.getNumberOffsetX(), config.getNumberOffsetY());
            }
        }
    }
}

