/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.armor_hud.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ArmorHudConfig {
    private static volatile ArmorHudConfig INSTANCE;
    private static final Gson GSON;
    private static final Path CONFIG_PATH;
    private int xOffset;
    private int yOffset;
    private int xOffsetLeft;
    private int yOffsetLeft;
    private int xOffsetRight;
    private int yOffsetRight;
    private boolean splitMode = false;
    private boolean vertical = false;
    private float durabilityWarningThreshold;
    private int boxSize;
    private int spacing;
    private boolean visible;
    private boolean showDurabilityBar;
    private boolean showDurabilityAsNumber;
    private boolean darkMode;
    private String language = "auto";
    public static final int DEFAULT_X_OFFSET_NORM_HOR = -220;
    public static final int DEFAULT_Y_OFFSET_NORM_HOR = -22;
    public static final int DEFAULT_X_OFFSET_NORM_VERT = -470;
    public static final int DEFAULT_Y_OFFSET_NORM_VERT = -102;
    public static final int DEFAULT_X_OFFSET_LEFT_SPLIT_HOR = -170;
    public static final int DEFAULT_Y_OFFSET_LEFT_SPLIT_HOR = -22;
    public static final int DEFAULT_X_OFFSET_RIGHT_SPLIT_HOR = 100;
    public static final int DEFAULT_Y_OFFSET_RIGHT_SPLIT_HOR = -22;
    public static final int DEFAULT_X_OFFSET_LEFT_SPLIT_VERT = -470;
    public static final int DEFAULT_Y_OFFSET_LEFT_SPLIT_VERT = -52;
    public static final int DEFAULT_X_OFFSET_RIGHT_SPLIT_VERT = 450;
    public static final int DEFAULT_Y_OFFSET_RIGHT_SPLIT_VERT = -52;
    private static final int DEFAULT_BOX_SIZE = 22;
    private static final int DEFAULT_SPACING = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArmorHudConfig getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ArmorHudConfig> clazz = ArmorHudConfig.class;
        synchronized (ArmorHudConfig.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = ArmorHudConfig.loadOrCreate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static ArmorHudConfig loadOrCreate() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (ArmorHudConfig)GSON.fromJson(json, ArmorHudConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
            }
        }
        return ArmorHudConfig.createDefaultConfig();
    }

    private static ArmorHudConfig createDefaultConfig() {
        ArmorHudConfig config = new ArmorHudConfig();
        config.boxSize = 22;
        config.spacing = 2;
        config.durabilityWarningThreshold = 0.2f;
        config.visible = true;
        config.showDurabilityBar = true;
        config.showDurabilityAsNumber = false;
        config.darkMode = false;
        config.language = "auto";
        config.splitMode = false;
        config.vertical = false;
        config.xOffset = -220;
        config.yOffset = -22;
        config.xOffsetLeft = -170;
        config.yOffsetLeft = -22;
        config.xOffsetRight = 100;
        config.yOffsetRight = -22;
        config.saveConfig();
        return config;
    }

    public void saveConfig() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    private void copyFrom(ArmorHudConfig other) {
        if (other != null) {
            this.xOffset = other.xOffset;
            this.yOffset = other.yOffset;
            this.xOffsetLeft = other.xOffsetLeft;
            this.yOffsetLeft = other.yOffsetLeft;
            this.xOffsetRight = other.xOffsetRight;
            this.yOffsetRight = other.yOffsetRight;
            this.splitMode = other.splitMode;
            this.vertical = other.vertical;
            this.durabilityWarningThreshold = other.durabilityWarningThreshold;
            this.boxSize = other.boxSize;
            this.spacing = other.spacing;
            this.visible = other.visible;
            this.showDurabilityBar = other.showDurabilityBar;
            this.showDurabilityAsNumber = other.showDurabilityAsNumber;
            this.darkMode = other.darkMode;
            this.language = other.language;
        }
    }

    public void setDefaultsForCurrentMode() {
        if (this.splitMode) {
            if (this.vertical) {
                this.xOffsetLeft = -470;
                this.yOffsetLeft = -52;
                this.xOffsetRight = 450;
                this.yOffsetRight = -52;
            } else {
                this.xOffsetLeft = -170;
                this.yOffsetLeft = -22;
                this.xOffsetRight = 100;
                this.yOffsetRight = -22;
            }
        } else if (this.vertical) {
            this.xOffset = -470;
            this.yOffset = -102;
        } else {
            this.xOffset = -220;
            this.yOffset = -22;
        }
    }

    public void resetToDefaults() {
        ArmorHudConfig defaults = ArmorHudConfig.createDefaultConfig();
        this.copyFrom(defaults);
        this.saveConfig();
    }

    public void onModeChanged(boolean newSplit, boolean newVertical) {
        this.splitMode = newSplit;
        this.vertical = newVertical;
        this.setDefaultsForCurrentMode();
        this.saveConfig();
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
        this.saveConfig();
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
        this.saveConfig();
    }

    public boolean isSplitMode() {
        return this.splitMode;
    }

    public void setSplitMode(boolean splitMode) {
        this.onModeChanged(splitMode, this.vertical);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.onModeChanged(this.splitMode, vertical);
    }

    public int getXOffsetLeft() {
        return this.xOffsetLeft;
    }

    public void setXOffsetLeft(int xOffsetLeft) {
        this.xOffsetLeft = xOffsetLeft;
        this.saveConfig();
    }

    public int getYOffsetLeft() {
        return this.yOffsetLeft;
    }

    public void setYOffsetLeft(int yOffsetLeft) {
        this.yOffsetLeft = yOffsetLeft;
        this.saveConfig();
    }

    public int getXOffsetRight() {
        return this.xOffsetRight;
    }

    public void setXOffsetRight(int xOffsetRight) {
        this.xOffsetRight = xOffsetRight;
        this.saveConfig();
    }

    public int getYOffsetRight() {
        return this.yOffsetRight;
    }

    public void setYOffsetRight(int yOffsetRight) {
        this.yOffsetRight = yOffsetRight;
        this.saveConfig();
    }

    public float getDurabilityWarningThreshold() {
        return this.durabilityWarningThreshold;
    }

    public void setDurabilityWarningThreshold(float threshold) {
        this.durabilityWarningThreshold = threshold;
        this.saveConfig();
    }

    public int getBoxSize() {
        return this.boxSize;
    }

    public void setBoxSize(int size) {
        this.boxSize = size;
        this.saveConfig();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.saveConfig();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.saveConfig();
    }

    public boolean isShowDurabilityBar() {
        return this.showDurabilityBar;
    }

    public void setShowDurabilityBar(boolean show) {
        this.showDurabilityBar = show;
        this.saveConfig();
    }

    public boolean isShowDurabilityAsNumber() {
        return this.showDurabilityAsNumber;
    }

    public void setShowDurabilityAsNumber(boolean show) {
        this.showDurabilityAsNumber = show;
        this.saveConfig();
    }

    public boolean isDarkMode() {
        return this.darkMode;
    }

    public void setDarkMode(boolean darkMode) {
        this.darkMode = darkMode;
        this.saveConfig();
    }

    public String getLanguage() {
        return this.language == null ? "auto" : this.language;
    }

    public void setLanguage(String lang) {
        this.language = lang == null ? "auto" : lang;
        this.saveConfig();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("armor_hud.json");
    }
}

