/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.armor_hud.client.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import de.mcjunky33.armor_hud.client.ArmorHudOverlay;
import de.mcjunky33.armor_hud.client.config.ArmorHudConfig;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> new SimpleConfigScreen(parent);
    }

    @Environment(value=EnvType.CLIENT)
    public static class SimpleConfigScreen
    extends class_437 {
        private final class_437 parent;
        private final ArmorHudConfig config;
        private class_342 xOffsetField;
        private class_342 yOffsetField;
        private class_342 boxSizeField;
        private class_342 spacingField;
        private class_342 xOffsetLeftField;
        private class_342 yOffsetLeftField;
        private class_342 xOffsetRightField;
        private class_342 yOffsetRightField;
        private static final Set<String> GERMAN_LANGS = Set.of("de_de", "de_at", "de_ch", "de_li", "de_lu", "de");
        private String currentLanguage;

        public SimpleConfigScreen(class_437 parent) {
            super((class_2561)class_2561.method_43470((String)"Armor HUD Configuration"));
            this.parent = parent;
            this.config = ArmorHudConfig.getInstance();
            this.currentLanguage = this.detectLanguage();
        }

        private String detectLanguage() {
            String configLang = this.config.getLanguage();
            if (!"auto".equals(configLang)) {
                return configLang;
            }
            String mcLang = class_310.method_1551().field_1690.field_1883;
            if (mcLang == null) {
                mcLang = "en_us";
            }
            return GERMAN_LANGS.contains(mcLang = mcLang.toLowerCase()) ? "de" : "en";
        }

        private String tr(String key) {
            if ("de".equals(this.currentLanguage)) {
                return switch (key) {
                    case "title" -> "Armor HUD Konfiguration";
                    case "config_tab" -> "Konfiguration";
                    case "hud_visible" -> "HUD Sichtbar";
                    case "durability_number" -> "Durability-Zahl";
                    case "durability_bar" -> "Durability-Balken";
                    case "darkmode" -> "Darkmode";
                    case "orientation" -> "Ausrichtung";
                    case "vertical" -> "Vertikal (untereinander)";
                    case "horizontal" -> "Horizontal (nebeneinander)";
                    case "splitmode_on" -> "Split-Modus: AN";
                    case "splitmode_off" -> "Split-Modus: AUS";
                    case "box_size" -> "Box-Gr\u00f6\u00dfe";
                    case "box_size_minus" -> "Box -2";
                    case "box_size_plus" -> "Box +2";
                    case "spacing" -> "Abstand";
                    case "spacing_minus" -> "Abstand -1";
                    case "spacing_plus" -> "Abstand +1";
                    case "defaults" -> "Standardwerte";
                    case "done" -> "Fertig";
                    case "offset_hint" -> "X = nach rechts, Y = nach unten";
                    case "lang_button_de" -> "Sprache: Deutsch";
                    case "lang_button_en" -> "Language: English";
                    case "left_coords" -> "Links";
                    case "right_coords" -> "Rechts";
                    default -> key;
                };
            }
            return switch (key) {
                case "title" -> "Armor HUD Configuration";
                case "config_tab" -> "Configuration";
                case "hud_visible" -> "HUD Visible";
                case "durability_number" -> "Durability Number";
                case "durability_bar" -> "Durability Bar";
                case "darkmode" -> "Darkmode";
                case "orientation" -> "Orientation";
                case "vertical" -> "Vertical (stacked)";
                case "horizontal" -> "Horizontal (side by side)";
                case "splitmode_on" -> "Split Mode: ON";
                case "splitmode_off" -> "Split Mode: OFF";
                case "box_size" -> "Box Size";
                case "box_size_minus" -> "Box -2";
                case "box_size_plus" -> "Box +2";
                case "spacing" -> "Spacing";
                case "spacing_minus" -> "Spacing -1";
                case "spacing_plus" -> "Spacing +1";
                case "defaults" -> "Defaults";
                case "done" -> "Done";
                case "offset_hint" -> "X = move right, Y = move down";
                case "lang_button_de" -> "Sprache: Deutsch";
                case "lang_button_en" -> "Language: English";
                case "left_coords" -> "Left";
                case "right_coords" -> "Right";
                default -> key;
            };
        }

        protected void method_25426() {
            int buttonWidth = 180;
            int smallButtonWidth = 50;
            int buttonHeight = 20;
            int fieldWidth = 40;
            int arrowBtn = 22;
            int centerX = this.field_22789 / 2 - buttonWidth / 2;
            int currentY = 35;
            int langBtnWidth = 120;
            String langBtnText = "de".equals(this.currentLanguage) ? this.tr("lang_button_de") : this.tr("lang_button_en");
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)langBtnText), button -> {
                this.config.setLanguage("de".equals(this.currentLanguage) ? "en" : "de");
                this.field_22787.method_1507((class_437)new SimpleConfigScreen(this.parent));
            }).method_46434(this.field_22789 - langBtnWidth - 20, 8, langBtnWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.tr("hud_visible") + ": " + (this.config.isVisible() ? ("de".equals(this.currentLanguage) ? "Ja" : "Yes") : ("de".equals(this.currentLanguage) ? "Nein" : "No")))), button -> {
                this.config.setVisible(!this.config.isVisible());
                button.method_25355((class_2561)class_2561.method_43470((String)(this.tr("hud_visible") + ": " + (this.config.isVisible() ? ("de".equals(this.currentLanguage) ? "Ja" : "Yes") : ("de".equals(this.currentLanguage) ? "Nein" : "No")))));
            }).method_46434(centerX, currentY, buttonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.tr("durability_number") + ": " + (this.config.isShowDurabilityAsNumber() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))), button -> {
                this.config.setShowDurabilityAsNumber(!this.config.isShowDurabilityAsNumber());
                button.method_25355((class_2561)class_2561.method_43470((String)(this.tr("durability_number") + ": " + (this.config.isShowDurabilityAsNumber() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))));
            }).method_46434(centerX, currentY += 30, buttonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.tr("durability_bar") + ": " + (this.config.isShowDurabilityBar() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))), button -> {
                this.config.setShowDurabilityBar(!this.config.isShowDurabilityBar());
                button.method_25355((class_2561)class_2561.method_43470((String)(this.tr("durability_bar") + ": " + (this.config.isShowDurabilityBar() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))));
            }).method_46434(centerX, currentY += 30, buttonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.tr("darkmode") + ": " + (this.config.isDarkMode() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))), button -> {
                this.config.setDarkMode(!this.config.isDarkMode());
                button.method_25355((class_2561)class_2561.method_43470((String)(this.tr("darkmode") + ": " + (this.config.isDarkMode() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))));
            }).method_46434(centerX, currentY += 30, buttonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.tr("orientation") + ": " + (this.config.isVertical() ? this.tr("vertical") : this.tr("horizontal")))), button -> {
                this.config.setVertical(!this.config.isVertical());
                button.method_25355((class_2561)class_2561.method_43470((String)(this.tr("orientation") + ": " + (this.config.isVertical() ? this.tr("vertical") : this.tr("horizontal")))));
            }).method_46434(centerX, currentY += 30, buttonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.isSplitMode() ? this.tr("splitmode_on") : this.tr("splitmode_off"))), button -> {
                this.config.setSplitMode(!this.config.isSplitMode());
                button.method_25355((class_2561)class_2561.method_43470((String)(this.config.isSplitMode() ? this.tr("splitmode_on") : this.tr("splitmode_off"))));
                this.field_22787.method_1507((class_437)new SimpleConfigScreen(this.parent));
            }).method_46434(centerX, currentY += 30, buttonWidth, buttonHeight).method_46431());
            int boxSizeBlockWidth = smallButtonWidth + fieldWidth + smallButtonWidth + 20;
            int boxSizeX = this.field_22789 / 2 - boxSizeBlockWidth / 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("box_size_minus")), button -> {
                this.config.setBoxSize(Math.max(16, this.config.getBoxSize() - 2));
                this.boxSizeField.method_1852(String.valueOf(this.config.getBoxSize()));
            }).method_46434(boxSizeX, currentY += 30, smallButtonWidth, buttonHeight).method_46431());
            this.boxSizeField = new class_342(this.field_22793, boxSizeX + smallButtonWidth + 10, currentY, fieldWidth, buttonHeight, (class_2561)class_2561.method_43470((String)""));
            this.boxSizeField.method_1852(String.valueOf(this.config.getBoxSize()));
            this.boxSizeField.method_1863(text -> {
                try {
                    this.config.setBoxSize(Math.max(16, Integer.parseInt(text)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.method_37063((class_364)this.boxSizeField);
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("box_size_plus")), button -> {
                this.config.setBoxSize(this.config.getBoxSize() + 2);
                this.boxSizeField.method_1852(String.valueOf(this.config.getBoxSize()));
            }).method_46434(boxSizeX + smallButtonWidth + 10 + fieldWidth + 10, currentY, smallButtonWidth, buttonHeight).method_46431());
            int spacingBlockWidth = smallButtonWidth + fieldWidth + smallButtonWidth + 20;
            int spacingX = this.field_22789 / 2 - spacingBlockWidth / 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("spacing_minus")), button -> {
                this.config.setSpacing(Math.max(0, this.config.getSpacing() - 1));
                this.spacingField.method_1852(String.valueOf(this.config.getSpacing()));
            }).method_46434(spacingX, currentY += 30, smallButtonWidth, buttonHeight).method_46431());
            this.spacingField = new class_342(this.field_22793, spacingX + smallButtonWidth + 10, currentY, fieldWidth, buttonHeight, (class_2561)class_2561.method_43470((String)""));
            this.spacingField.method_1852(String.valueOf(this.config.getSpacing()));
            this.spacingField.method_1863(text -> {
                try {
                    this.config.setSpacing(Math.max(0, Integer.parseInt(text)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.method_37063((class_364)this.spacingField);
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("spacing_plus")), button -> {
                this.config.setSpacing(this.config.getSpacing() + 1);
                this.spacingField.method_1852(String.valueOf(this.config.getSpacing()));
            }).method_46434(spacingX + smallButtonWidth + 10 + fieldWidth + 10, currentY, smallButtonWidth, buttonHeight).method_46431());
            currentY += 30;
            if (this.config.isSplitMode()) {
                int leftBlockWidth = arrowBtn * 2 + fieldWidth + 20;
                int leftBlockX = this.field_22789 / 2 - leftBlockWidth - 10;
                int fieldY = currentY;
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), btn -> {
                    this.config.setXOffsetLeft(this.config.getXOffsetLeft() - 10);
                    this.xOffsetLeftField.method_1852(String.valueOf(this.config.getXOffsetLeft()));
                }).method_46434(leftBlockX, fieldY, arrowBtn, buttonHeight).method_46431());
                this.xOffsetLeftField = new class_342(this.field_22793, leftBlockX + arrowBtn + 5, fieldY, fieldWidth, buttonHeight, (class_2561)class_2561.method_43470((String)""));
                this.xOffsetLeftField.method_1852(String.valueOf(this.config.getXOffsetLeft()));
                this.xOffsetLeftField.method_1863(txt -> {
                    try {
                        this.config.setXOffsetLeft(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.xOffsetLeftField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), btn -> {
                    this.config.setXOffsetLeft(this.config.getXOffsetLeft() + 10);
                    this.xOffsetLeftField.method_1852(String.valueOf(this.config.getXOffsetLeft()));
                }).method_46434(leftBlockX + arrowBtn + 5 + fieldWidth + 5, fieldY, arrowBtn, buttonHeight).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), btn -> {
                    this.config.setYOffsetLeft(this.config.getYOffsetLeft() - 10);
                    this.yOffsetLeftField.method_1852(String.valueOf(this.config.getYOffsetLeft()));
                }).method_46434(leftBlockX, fieldY += buttonHeight + 4, arrowBtn, buttonHeight).method_46431());
                this.yOffsetLeftField = new class_342(this.field_22793, leftBlockX + arrowBtn + 5, fieldY, fieldWidth, buttonHeight, (class_2561)class_2561.method_43470((String)""));
                this.yOffsetLeftField.method_1852(String.valueOf(this.config.getYOffsetLeft()));
                this.yOffsetLeftField.method_1863(txt -> {
                    try {
                        this.config.setYOffsetLeft(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.yOffsetLeftField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), btn -> {
                    this.config.setYOffsetLeft(this.config.getYOffsetLeft() + 10);
                    this.yOffsetLeftField.method_1852(String.valueOf(this.config.getYOffsetLeft()));
                }).method_46434(leftBlockX + arrowBtn + 5 + fieldWidth + 5, fieldY, arrowBtn, buttonHeight).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("left_coords")), btn -> {}).method_46434(leftBlockX, fieldY + buttonHeight + 4, fieldWidth + arrowBtn * 2 + 10, buttonHeight).method_46431());
                int rightBlockWidth = arrowBtn * 2 + fieldWidth + 20;
                int rightBlockX = this.field_22789 / 2 + 10;
                fieldY = currentY;
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), btn -> {
                    this.config.setXOffsetRight(this.config.getXOffsetRight() - 10);
                    this.xOffsetRightField.method_1852(String.valueOf(this.config.getXOffsetRight()));
                }).method_46434(rightBlockX, fieldY, arrowBtn, buttonHeight).method_46431());
                this.xOffsetRightField = new class_342(this.field_22793, rightBlockX + arrowBtn + 5, fieldY, fieldWidth, buttonHeight, (class_2561)class_2561.method_43470((String)""));
                this.xOffsetRightField.method_1852(String.valueOf(this.config.getXOffsetRight()));
                this.xOffsetRightField.method_1863(txt -> {
                    try {
                        this.config.setXOffsetRight(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.xOffsetRightField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), btn -> {
                    this.config.setXOffsetRight(this.config.getXOffsetRight() + 10);
                    this.xOffsetRightField.method_1852(String.valueOf(this.config.getXOffsetRight()));
                }).method_46434(rightBlockX + arrowBtn + 5 + fieldWidth + 5, fieldY, arrowBtn, buttonHeight).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), btn -> {
                    this.config.setYOffsetRight(this.config.getYOffsetRight() - 10);
                    this.yOffsetRightField.method_1852(String.valueOf(this.config.getYOffsetRight()));
                }).method_46434(rightBlockX, fieldY += buttonHeight + 4, arrowBtn, buttonHeight).method_46431());
                this.yOffsetRightField = new class_342(this.field_22793, rightBlockX + arrowBtn + 5, fieldY, fieldWidth, buttonHeight, (class_2561)class_2561.method_43470((String)""));
                this.yOffsetRightField.method_1852(String.valueOf(this.config.getYOffsetRight()));
                this.yOffsetRightField.method_1863(txt -> {
                    try {
                        this.config.setYOffsetRight(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.yOffsetRightField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), btn -> {
                    this.config.setYOffsetRight(this.config.getYOffsetRight() + 10);
                    this.yOffsetRightField.method_1852(String.valueOf(this.config.getYOffsetRight()));
                }).method_46434(rightBlockX + arrowBtn + 5 + fieldWidth + 5, fieldY, arrowBtn, buttonHeight).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("right_coords")), btn -> {}).method_46434(rightBlockX, fieldY + buttonHeight + 4, fieldWidth + arrowBtn * 2 + 10, buttonHeight).method_46431());
                currentY += (buttonHeight + 4) * 2 + buttonHeight + 8;
            } else {
                int xBlockWidth = arrowBtn * 2 + fieldWidth + 20;
                int xBlockX = this.field_22789 / 2 - xBlockWidth / 2;
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), button -> {
                    this.config.setXOffset(this.config.getXOffset() - 10);
                    this.xOffsetField.method_1852(String.valueOf(this.config.getXOffset()));
                }).method_46434(xBlockX, currentY, arrowBtn, buttonHeight).method_46431());
                this.xOffsetField = new class_342(this.field_22793, xBlockX + arrowBtn + 5, currentY, fieldWidth, buttonHeight, (class_2561)class_2561.method_43470((String)""));
                this.xOffsetField.method_1852(String.valueOf(this.config.getXOffset()));
                this.xOffsetField.method_1863(text -> {
                    try {
                        this.config.setXOffset(Integer.parseInt(text));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.xOffsetField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), button -> {
                    this.config.setXOffset(this.config.getXOffset() + 10);
                    this.xOffsetField.method_1852(String.valueOf(this.config.getXOffset()));
                }).method_46434(xBlockX + arrowBtn + 5 + fieldWidth + 5, currentY, arrowBtn, buttonHeight).method_46431());
                int yBlockWidth = arrowBtn * 2 + fieldWidth + 20;
                int yBlockX = this.field_22789 / 2 - yBlockWidth / 2;
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> {
                    this.config.setYOffset(this.config.getYOffset() - 10);
                    this.yOffsetField.method_1852(String.valueOf(this.config.getYOffset()));
                }).method_46434(yBlockX, currentY += buttonHeight + 4, arrowBtn, buttonHeight).method_46431());
                this.yOffsetField = new class_342(this.field_22793, yBlockX + arrowBtn + 5, currentY, fieldWidth, buttonHeight, (class_2561)class_2561.method_43470((String)""));
                this.yOffsetField.method_1852(String.valueOf(this.config.getYOffset()));
                this.yOffsetField.method_1863(text -> {
                    try {
                        this.config.setYOffset(Integer.parseInt(text));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.yOffsetField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> {
                    this.config.setYOffset(this.config.getYOffset() + 10);
                    this.yOffsetField.method_1852(String.valueOf(this.config.getYOffset()));
                }).method_46434(yBlockX + arrowBtn + 5 + fieldWidth + 5, currentY, arrowBtn, buttonHeight).method_46431());
                currentY += buttonHeight + 4;
            }
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("defaults")), button -> {
                this.config.resetToDefaults();
                this.field_22787.method_1507((class_437)new SimpleConfigScreen(this.parent));
            }).method_46434(centerX, currentY, buttonWidth, buttonHeight).method_46431());
            currentY += 30;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("done")), button -> {
                assert (this.field_22787 != null);
                this.field_22787.method_1507(this.parent);
            }).method_46434(this.field_22789 / 2 - buttonWidth / 2, this.field_22790 - 40, buttonWidth, buttonHeight).method_46431());
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25300(this.field_22793, this.tr("title"), this.field_22789 / 2, 12, 0xFFFFFF);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.tr("offset_hint")), this.field_22789 / 2, 110, 0xAAAAAA);
            super.method_25394(context, mouseX, mouseY, delta);
            ArmorHudOverlay.renderPreview(context, this.field_22789, this.field_22790, this.config);
            context.method_25303(this.field_22793, "by Mcjunky33", 8, this.field_22790 - 18, 0x777777);
        }
    }
}

