/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor;

import com.mojang.logging.LogUtils;
import com.portingdeadmods.portingdeadlibs.api.config.PDLConfigHelper;
import com.portingdeadmods.portingdeadlibs.api.data.PDLDataComponents;
import com.portingdeadmods.power_armor.PARegistries;
import com.portingdeadmods.power_armor.PowerArmorConfig;
import com.portingdeadmods.power_armor.capabilities.PAComponentEnergyStorage;
import com.portingdeadmods.power_armor.client.InputHandler;
import com.portingdeadmods.power_armor.data.PAComponents;
import com.portingdeadmods.power_armor.networking.ArmorWidgetOpenClosePayload;
import com.portingdeadmods.power_armor.networking.ArmorWidgetSetSlotPositionsPayload;
import com.portingdeadmods.power_armor.networking.SetAttackTypePayload;
import com.portingdeadmods.power_armor.networking.UpdateInputPayload;
import com.portingdeadmods.power_armor.registries.PAArmorMaterials;
import com.portingdeadmods.power_armor.registries.PAArmorModules;
import com.portingdeadmods.power_armor.registries.PAAttachments;
import com.portingdeadmods.power_armor.registries.PABlockEntityTypes;
import com.portingdeadmods.power_armor.registries.PABlocks;
import com.portingdeadmods.power_armor.registries.PACreativeTabs;
import com.portingdeadmods.power_armor.registries.PAItems;
import com.portingdeadmods.power_armor.registries.PAMenuTypes;
import com.portingdeadmods.power_armor.registries.PARecipeSerializers;
import com.portingdeadmods.power_armor.registries.PASoundEvents;
import com.portingdeadmods.power_armor.registries.PATranslations;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.ComponentEnergyStorage;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="power_armor")
public final class PowerArmor {
    public static final String MODID = "power_armor";
    public static final String MODNAME = "Power Armor";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PowerArmor(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::registerPayloads);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::registerRegistries);
        PAAttachments.ATTACHMENTS.register(modEventBus);
        PAArmorModules.ARMOR_MODULES.register(modEventBus);
        PAItems.ITEMS.register(modEventBus);
        PABlocks.BLOCKS.register(modEventBus);
        PAComponents.COMPONENTS.register(modEventBus);
        PATranslations.TRANSLATIONS.register(modEventBus);
        PACreativeTabs.TABS.register(modEventBus);
        PABlockEntityTypes.BLOCK_ENTITY_TYPES.register(modEventBus);
        PAMenuTypes.MENU_TYPES.register(modEventBus);
        PARecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        PAArmorMaterials.ARMOR_MATERIALS.register(modEventBus);
        PASoundEvents.SOUND_EVENTS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)new InputHandler());
        PDLConfigHelper.registerConfig(PowerArmorConfig.class, (ModConfig.Type)ModConfig.Type.COMMON).register(modContainer);
    }

    private void registerRegistries(NewRegistryEvent event) {
        event.register(PARegistries.ARMOR_MODULE);
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        registrar.playToServer(UpdateInputPayload.TYPE, UpdateInputPayload.STREAM_CODEC, UpdateInputPayload::handle);
        registrar.playToServer(ArmorWidgetOpenClosePayload.TYPE, ArmorWidgetOpenClosePayload.STREAM_CODEC, ArmorWidgetOpenClosePayload::handle);
        registrar.playToServer(ArmorWidgetSetSlotPositionsPayload.TYPE, ArmorWidgetSetSlotPositionsPayload.STREAM_CODEC, ArmorWidgetSetSlotPositionsPayload::handle);
        registrar.playToServer(SetAttackTypePayload.TYPE, SetAttackTypePayload.STREAM_CODEC, SetAttackTypePayload::handle);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> PowerArmor.getComponentEnergyStorage(stack, PowerArmorConfig.batteryEnergyCapacity, PowerArmorConfig.batteryEnergyTransfer), new ItemLike[]{(ItemLike)PAItems.BATTERY.get()});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> PowerArmor.getComponentEnergyStorage(stack, PowerArmorConfig.powerArmorEnergyTransfer), new ItemLike[]{(ItemLike)PAItems.POWER_ARMOR_HELMET.get()});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> PowerArmor.getComponentEnergyStorage(stack, PowerArmorConfig.powerArmorEnergyTransfer), new ItemLike[]{(ItemLike)PAItems.POWER_ARMOR_CHESTPLATE.get()});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> PowerArmor.getComponentEnergyStorage(stack, PowerArmorConfig.powerArmorEnergyTransfer), new ItemLike[]{(ItemLike)PAItems.POWER_ARMOR_LEGGINGS.get()});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> PowerArmor.getComponentEnergyStorage(stack, PowerArmorConfig.powerArmorEnergyTransfer), new ItemLike[]{(ItemLike)PAItems.POWER_ARMOR_BOOTS.get()});
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, PABlockEntityTypes.COMPRESSOR.get(), (be, ctx) -> be.getEnergyStorage());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, PABlockEntityTypes.COMPRESSOR.get(), (be, ctx) -> be.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, PABlockEntityTypes.ARMOR_MODIFICATION_TABLE.get(), (be, ctx) -> be.getItemHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, PABlockEntityTypes.ARMOR_MODIFICATION_TABLE.get(), (be, ctx) -> be.getEnergyStorage());
    }

    @NotNull
    private static ComponentEnergyStorage getComponentEnergyStorage(ItemStack stack, int capacity, int transfer) {
        return new PAComponentEnergyStorage((MutableDataComponentHolder)stack, (DataComponentType<Integer>)((DataComponentType)PDLDataComponents.ENERGY.get()), capacity, transfer);
    }

    @NotNull
    private static ComponentEnergyStorage getComponentEnergyStorage(ItemStack stack, int transfer) {
        return new PAComponentEnergyStorage((MutableDataComponentHolder)stack, (DataComponentType<Integer>)((DataComponentType)PDLDataComponents.ENERGY.get()), (Integer)stack.get(PAComponents.ENERGY_CAPACITY.get()), transfer);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

