/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.api.modules;

import com.portingdeadmods.portingdeadlibs.utils.Utils;
import com.portingdeadmods.power_armor.PARegistries;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public interface ArmorModule {
    public static final ArmorModule EMPTY = new ArmorModule(){

        @Override
        public Item getItem() {
            return Items.AIR;
        }

        @Override
        public Component getDisplayName() {
            return Component.literal((String)"Empty");
        }

        @Override
        public Set<ArmorItem.Type> getArmorTypes() {
            return Set.of();
        }
    };

    public Item getItem();

    default public Component getDisplayName() {
        return Utils.registryTranslation(PARegistries.ARMOR_MODULE, (Object)this);
    }

    @Nullable
    public Set<ArmorItem.Type> getArmorTypes();

    default public int getEnergyUsage(ItemStack stack) {
        return 0;
    }

    default public void addTooltip(ItemStack stack, List<Component> tooltipComponents) {
    }

    default public void tick(ItemStack armorItem, Player player) {
    }

    default public void onAdded(ItemStack armorItem) {
    }

    default public void onRemoved(ItemStack armorItem) {
    }

    default public void onArmorUnequipped(Player player, ItemStack armorItem) {
    }

    default public void onPlayerAttacked(Player player, ItemStack armorItem) {
    }

    default public boolean isActive(ItemStack armorItem) {
        IEnergyStorage energyStorage = (IEnergyStorage)armorItem.getCapability(Capabilities.EnergyStorage.ITEM);
        return energyStorage.getEnergyStored() >= this.getEnergyUsage(armorItem);
    }

    default public void extractEnergy(ItemStack armorItem) {
        this.extractEnergy(armorItem, this.getEnergyUsage(armorItem));
    }

    default public void extractEnergy(ItemStack armorItem, int usage) {
        IEnergyStorage energyStorage = (IEnergyStorage)armorItem.getCapability(Capabilities.EnergyStorage.ITEM);
        energyStorage.extractEnergy(usage, false);
    }

    @Nullable
    public static ArmorModule byItem(Item item) {
        for (ArmorModule armorModule : PARegistries.ARMOR_MODULE) {
            if (!armorModule.getItem().equals(item)) continue;
            return armorModule;
        }
        return null;
    }
}

