/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.client.overlays;

import com.portingdeadmods.portingdeadlibs.api.capabilities.EnergyStorageWrapper;
import com.portingdeadmods.power_armor.PowerArmor;
import com.portingdeadmods.power_armor.utils.ArmorUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class EnergyBarOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ENERGY_BAR_SPRITE = PowerArmor.rl("energy_bar");
    public static final ResourceLocation ENERGY_BAR_EMPTY_SPRITE = PowerArmor.rl("energy_bar_empty");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int width = 80;
        int height = 12;
        int x = guiGraphics.guiWidth() - width - 8;
        int y = guiGraphics.guiHeight() - height - 4;
        EnergyStorageWrapper wrapper = ArmorUtils.getEnergy((Player)Minecraft.getInstance().player);
        int energyStored = wrapper.getEnergyStored();
        int maxStored = wrapper.getEnergyCapacity();
        if (maxStored != 0) {
            guiGraphics.blitSprite(ENERGY_BAR_EMPTY_SPRITE, width, height, 0, 0, x, y, width, height);
            int progress = (int)((float)width * ((float)energyStored / (float)maxStored));
            guiGraphics.blitSprite(ENERGY_BAR_SPRITE, width, height, width - progress, 0, x + width - progress, y, progress, height);
            String text = "%.0f%%".formatted(Float.valueOf((float)energyStored / (float)maxStored * 100.0f));
            guiGraphics.drawString(Minecraft.getInstance().font, text, x - Minecraft.getInstance().font.width(text) - 2, y + 2, -1);
        }
    }
}

