/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.client.screens.widgets;

import com.portingdeadmods.portingdeadlibs.api.client.screens.widgets.PanelWidget;
import com.portingdeadmods.portingdeadlibs.api.gui.menus.PDLAbstractContainerMenu;
import com.portingdeadmods.power_armor.PowerArmor;
import com.portingdeadmods.power_armor.content.menus.ArmorModificationTableMenu;
import com.portingdeadmods.power_armor.content.menus.ArmorSlot;
import com.portingdeadmods.power_armor.networking.ArmorWidgetOpenClosePayload;
import com.portingdeadmods.power_armor.networking.ArmorWidgetSetSlotPositionsPayload;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public class ArmorPanelWidget
extends PanelWidget {
    public static final ResourceLocation WIDGET_SPRITE = PowerArmor.rl("widget/widget_armor_right");
    public static final ResourceLocation WIDGET_OPEN_SPRITE = PowerArmor.rl("widget/widget_armor_open");
    public static final int WIDGET_WIDTH = 32;
    public static final int WIDGET_HEIGHT = 32;
    public static final int WIDGET_OPEN_WIDTH = 32;
    public static final int WIDGET_OPEN_HEIGHT = 112;

    public ArmorPanelWidget(int x, int y) {
        super(x, y, 32, 112, 32, 32);
        this.open = false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean isHovered;
        boolean bl = isHovered = mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.getClosedWidth()) && mouseY < (double)(this.getY() + (this.getClosedHeight() - 4));
        if (isHovered) {
            this.open = !this.open;
            PacketDistributor.sendToServer((CustomPacketPayload)new ArmorWidgetOpenClosePayload(this.open), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PDLAbstractContainerMenu pDLAbstractContainerMenu = this.context.menu();
            if (pDLAbstractContainerMenu instanceof ArmorModificationTableMenu) {
                ArmorModificationTableMenu menu = (ArmorModificationTableMenu)pDLAbstractContainerMenu;
                for (ArmorSlot armorslot : menu.getArmorSlots()) {
                    armorslot.setActive(this.open);
                }
            }
            if (this.open) {
                this.setSize(32, 112);
            } else {
                this.setSize(32, 32);
            }
            this.context.onWidgetResizeFunc().accept(this);
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        if (this.open) {
            guiGraphics.blitSprite(WIDGET_OPEN_SPRITE, this.getX(), this.getY(), 32, 112);
        } else {
            guiGraphics.blitSprite(WIDGET_SPRITE, this.getX(), this.getY(), 32, 32);
        }
    }

    public void onWidgetResized(PanelWidget resizedWidget) {
        super.onWidgetResized(resizedWidget);
        PDLAbstractContainerMenu pDLAbstractContainerMenu = this.context.menu();
        if (pDLAbstractContainerMenu instanceof ArmorModificationTableMenu) {
            ArmorModificationTableMenu menu = (ArmorModificationTableMenu)pDLAbstractContainerMenu;
            if (resizedWidget.isOpen()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ArmorWidgetSetSlotPositionsPayload(27 + resizedWidget.getOpenHeight()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                menu.setArmorSlotPositions(27 + resizedWidget.getOpenHeight());
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new ArmorWidgetSetSlotPositionsPayload(46), (CustomPacketPayload[])new CustomPacketPayload[0]);
                menu.setArmorSlotPositions(46);
            }
        }
    }
}

