/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.compat;

import com.portingdeadmods.power_armor.PowerArmor;
import com.portingdeadmods.power_armor.client.screens.ArmorModificationTableScreen;
import com.portingdeadmods.power_armor.client.screens.CompressorScreen;
import com.portingdeadmods.power_armor.compat.CompressingCategory;
import com.portingdeadmods.power_armor.compat.JeiWidgetBounds;
import com.portingdeadmods.power_armor.content.recipes.CompressingRecipe;
import com.portingdeadmods.power_armor.registries.PABlocks;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public final class PAJeiPlugin
implements IModPlugin {
    public static final ResourceLocation UID = PowerArmor.rl("jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        super.registerCategories(registration);
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        super.registerRecipeCatalysts(registration);
        registration.addRecipeCatalyst(PABlocks.COMPRESSOR, new RecipeType[]{CompressingCategory.TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        super.registerRecipes(registration);
        ClientLevel level = Minecraft.getInstance().level;
        RecipeManager recipeManager = level.getRecipeManager();
        List<CompressingRecipe> recipes = recipeManager.getAllRecipesFor(CompressingRecipe.TYPE).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(CompressingCategory.TYPE, recipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(CompressorScreen.class, (IGuiContainerHandler)new JeiWidgetBounds());
        registration.addGenericGuiContainerHandler(ArmorModificationTableScreen.class, (IGuiContainerHandler)new JeiWidgetBounds());
    }
}

