/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.content.items;

import com.portingdeadmods.portingdeadlibs.api.data.PDLDataComponents;
import com.portingdeadmods.portingdeadlibs.api.items.IEnergyItem;
import com.portingdeadmods.power_armor.PowerArmorConfig;
import com.portingdeadmods.power_armor.api.modules.ArmorModule;
import com.portingdeadmods.power_armor.content.items.ArmorRemoveHandler;
import com.portingdeadmods.power_armor.content.items.PowerArmorTooltipComponent;
import com.portingdeadmods.power_armor.data.PAComponents;
import com.portingdeadmods.power_armor.data.components.ArmorModulesComponent;
import com.portingdeadmods.power_armor.registries.PAArmorMaterials;
import com.portingdeadmods.power_armor.registries.PAArmorModules;
import com.portingdeadmods.power_armor.registries.PATranslations;
import com.portingdeadmods.power_armor.utils.ArmorModuleUtils;
import com.portingdeadmods.power_armor.utils.ItemBarUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerArmorItem
extends ArmorItem
implements IEnergyItem,
ArmorRemoveHandler {
    public static final ResourceLocation ARMOR_TEXTURE_LAYER_1 = ResourceLocation.withDefaultNamespace((String)"textures/models/armor/power_armor_layer_1.png");
    public static final ResourceLocation ARMOR_TEXTURE_LAYER_SOLAR = ResourceLocation.withDefaultNamespace((String)"textures/models/armor/power_armor_layer_solar.png");
    public static final ResourceLocation ARMOR_TEXTURE_LAYER_2 = ResourceLocation.withDefaultNamespace((String)"textures/models/armor/power_armor_layer_2.png");

    public PowerArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(PAArmorMaterials.POWER_ARMOR.getDelegate(), type, properties);
    }

    public int getEnergyCapacity() {
        return PowerArmorConfig.powerArmorEnergyCapacity;
    }

    public int getMaxTransfer() {
        return PowerArmorConfig.powerArmorEnergyTransfer;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return ItemBarUtils.energyBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return ItemBarUtils.energyBarColor(stack);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new PowerArmorTooltipComponent((ArmorModulesComponent)stack.get(PAComponents.ARMOR_MODULES)));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        ItemStack itemBySlot;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player && (itemBySlot = (player = (Player)entity).getItemBySlot(this.type.getSlot())) == stack) {
            ArmorModulesComponent armorModulesComponent = (ArmorModulesComponent)stack.get(PAComponents.ARMOR_MODULES);
            for (ArmorModule module : armorModulesComponent.modulesUnsafe()) {
                module.tick(stack, player);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (!tooltipFlag.hasShiftDown()) {
            tooltip.add((Component)Component.literal((String)"<Press SHIFT for more info>").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)PATranslations.BATTERY_TOOLTIP.component(new Object[]{stack.get(PDLDataComponents.ENERGY), stack.getOrDefault(PAComponents.ENERGY_CAPACITY, (Object)this.getEnergyCapacity())}).withColor(FastColor.ARGB32.color((int)255, (int)245, (int)192, (int)89)));
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage != null && energyStorage.getEnergyStored() > 0) {
            return (ItemAttributeModifiers)stack.getOrDefault(PAComponents.DEFAULT_ATTRIBUTES, (Object)ItemAttributeModifiers.EMPTY);
        }
        return ItemAttributeModifiers.EMPTY;
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        if (!innerModel && ArmorModuleUtils.hasModule(stack, PAArmorModules.SOLAR)) {
            return ARMOR_TEXTURE_LAYER_SOLAR;
        }
        return innerModel ? ARMOR_TEXTURE_LAYER_2 : ARMOR_TEXTURE_LAYER_1;
    }

    @Override
    public void onArmorRemoved(Player player, ItemStack armorItem) {
        ((ArmorModulesComponent)armorItem.get(PAComponents.ARMOR_MODULES)).modulesUnsafe().forEach(m -> m.onArmorUnequipped(player, armorItem));
    }
}

