/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.content.modules;

import com.portingdeadmods.power_armor.PowerArmorConfig;
import com.portingdeadmods.power_armor.api.modules.ArmorModule;
import com.portingdeadmods.power_armor.capabilities.PAComponentEnergyStorage;
import com.portingdeadmods.power_armor.data.PAComponents;
import com.portingdeadmods.power_armor.registries.PAItems;
import java.util.Set;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyArmorModule
implements ArmorModule {
    public static final Set<ArmorItem.Type> TYPES = Set.of(ArmorItem.Type.values());

    @Override
    public Item getItem() {
        return (Item)PAItems.ENERGY_ARMOR_MODULE.get();
    }

    @Override
    @Nullable
    public Set<ArmorItem.Type> getArmorTypes() {
        return TYPES;
    }

    @Override
    public void onAdded(ItemStack armorItem) {
        if (armorItem.has(PAComponents.ENERGY_CAPACITY)) {
            armorItem.set(PAComponents.ENERGY_CAPACITY, (Object)(PowerArmorConfig.powerArmorEnergyCapacity * PowerArmorConfig.powerArmorEnergyModuleMultiplier));
        }
    }

    @Override
    public void onRemoved(ItemStack armorItem) {
        if (armorItem.has(PAComponents.ENERGY_CAPACITY)) {
            IEnergyStorage energyStorage = (IEnergyStorage)armorItem.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage instanceof PAComponentEnergyStorage) {
                PAComponentEnergyStorage energyStorage1 = (PAComponentEnergyStorage)energyStorage;
                energyStorage1.setEnergy(Math.min(PowerArmorConfig.powerArmorEnergyCapacity, energyStorage.getEnergyStored()));
            }
            armorItem.set(PAComponents.ENERGY_CAPACITY, (Object)PowerArmorConfig.powerArmorEnergyCapacity);
        }
    }
}

