/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.content.modules;

import com.portingdeadmods.power_armor.PowerArmorConfig;
import com.portingdeadmods.power_armor.api.modules.ArmorModule;
import com.portingdeadmods.power_armor.client.InputHandler;
import com.portingdeadmods.power_armor.registries.PAItems;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class JetpackArmorModule
implements ArmorModule {
    public static final Set<ArmorItem.Type> TYPES = Set.of(ArmorItem.Type.CHESTPLATE);

    @Override
    public Item getItem() {
        return (Item)PAItems.JETPACK_ARMOR_MODULE.get();
    }

    @Override
    public Set<ArmorItem.Type> getArmorTypes() {
        return TYPES;
    }

    @Override
    public int getEnergyUsage(ItemStack stack) {
        return PowerArmorConfig.powerArmorJetpackModuleEnergyUsage;
    }

    @Override
    public void tick(ItemStack stack, Player player) {
        if (!this.isActive(stack)) {
            return;
        }
        Level level = player.level();
        boolean hover = false;
        if (InputHandler.isHoldingUp(player) || hover && !player.onGround()) {
            double usage;
            double motionY = player.getDeltaMovement().y();
            double speedHoverDescend = 0.25;
            double speedHoverSlow = 0.075;
            double hoverSpeed = InputHandler.isHoldingDown(player) ? speedHoverDescend : speedHoverSlow;
            double accelVert = 0.12;
            double currentAccel = accelVert * (motionY < 0.3 ? 2.5 : 1.0);
            double speedVert = 0.41;
            double currentSpeedVertical = speedVert * (player.isInWater() ? 0.4 : 1.0);
            double sprintFuel = 2.1;
            double d = usage = player.isSprinting() || InputHandler.isHoldingSprint(player) ? (double)this.getEnergyUsage(stack) * sprintFuel : (double)this.getEnergyUsage(stack);
            if (!player.isCreative()) {
                this.extractEnergy(stack, (int)usage);
            }
            if (hover && player.isFallFlying()) {
                player.stopFallFlying();
            }
            if (this.isActive(stack) || player.isCreative()) {
                double verticalSprintMulti;
                double throttle = 1.0;
                double sprintSpeedVert = 1.05;
                double d2 = verticalSprintMulti = motionY >= 0.0 && InputHandler.isHoldingSprint(player) ? sprintSpeedVert : 1.0;
                if (InputHandler.isHoldingUp(player)) {
                    if (!hover) {
                        JetpackArmorModule.fly(player, Math.min(motionY + currentAccel, currentSpeedVertical) * throttle * verticalSprintMulti);
                    } else if (InputHandler.isHoldingDown(player)) {
                        JetpackArmorModule.fly(player, Math.min(motionY + currentAccel, -speedHoverSlow));
                    } else {
                        double speedHoverAscend = 0.27;
                        JetpackArmorModule.fly(player, Math.min(motionY + currentAccel, speedHoverAscend) * throttle * verticalSprintMulti);
                    }
                } else {
                    JetpackArmorModule.fly(player, Math.min(motionY + currentAccel, -hoverSpeed));
                }
                double speedSide = 0.14;
                double speedSideways = (player.isCrouching() ? speedSide * 0.5 : speedSide) * throttle;
                double sprintSpeed = 1.1;
                double speedForward = (player.isSprinting() ? speedSideways * sprintSpeed : speedSideways) * throttle;
                if (!player.isFallFlying()) {
                    if (InputHandler.isHoldingForwards(player)) {
                        player.moveRelative(1.0f, new Vec3(0.0, 0.0, speedForward));
                    }
                    if (InputHandler.isHoldingBackwards(player)) {
                        player.moveRelative(1.0f, new Vec3(0.0, 0.0, -speedSideways * (double)0.8f));
                    }
                    if (InputHandler.isHoldingLeft(player)) {
                        player.moveRelative(1.0f, new Vec3(speedSideways, 0.0, 0.0));
                    }
                    if (InputHandler.isHoldingRight(player)) {
                        player.moveRelative(1.0f, new Vec3(-speedSideways, 0.0, 0.0));
                    }
                }
                if (!level.isClientSide()) {
                    player.fallDistance = 0.0f;
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.connection.aboveGroundTickCount = 0;
                    }
                }
            }
        }
    }

    private static void fly(Player player, double y) {
        Vec3 motion = player.getDeltaMovement();
        player.setDeltaMovement(motion.x(), y, motion.z());
    }
}

