/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.content.modules;

import com.portingdeadmods.power_armor.PowerArmorConfig;
import com.portingdeadmods.power_armor.api.modules.ArmorModule;
import com.portingdeadmods.power_armor.registries.PAItems;
import java.util.Set;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class SolarArmorModule
implements ArmorModule {
    public static final Set<ArmorItem.Type> TYPES = Set.of(ArmorItem.Type.HELMET);

    @Override
    public Item getItem() {
        return (Item)PAItems.SOLAR_ARMOR_MODULE.get();
    }

    @Override
    @Nullable
    public Set<ArmorItem.Type> getArmorTypes() {
        return TYPES;
    }

    public int getEnergyProduction(ItemStack stack) {
        return PowerArmorConfig.powerArmorSolarModuleEnergyProduction;
    }

    @Override
    public void tick(ItemStack armorItem, Player player) {
        if (!this.isActive(armorItem)) {
            return;
        }
        Iterable armorStacks = player.getArmorSlots();
        Level level = player.level();
        if (!level.isNight() && !level.isClientSide()) {
            for (ItemStack stack : armorStacks) {
                IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyStorage == null) continue;
                energyStorage.receiveEnergy(this.getEnergyProduction(armorItem), false);
            }
        }
    }
}

