/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.portingdeadlibs.api.recipes.IngredientWithCount;
import com.portingdeadmods.portingdeadlibs.api.recipes.PDLRecipe;
import com.portingdeadmods.power_armor.PowerArmor;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record CompressingRecipe(IngredientWithCount ingredient, int duration, ItemStack result) implements PDLRecipe<SingleRecipeInput>
{
    public static final RecipeType<CompressingRecipe> TYPE = RecipeType.simple((ResourceLocation)PowerArmor.rl("compressing"));

    public boolean matches(SingleRecipeInput singleRecipeInput, Level level) {
        return this.ingredient.test(singleRecipeInput.getItem(0));
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return TYPE;
    }

    public static final class Serializer
    implements RecipeSerializer<CompressingRecipe> {
        public static final MapCodec<CompressingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IngredientWithCount.CODEC.fieldOf("ingredient").forGetter(CompressingRecipe::ingredient), (App)Codec.INT.fieldOf("duration").forGetter(CompressingRecipe::duration), (App)ItemStack.CODEC.fieldOf("result").forGetter(CompressingRecipe::result)).apply((Applicative)inst, CompressingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CompressingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)IngredientWithCount.STREAM_CODEC, CompressingRecipe::ingredient, (StreamCodec)ByteBufCodecs.INT, CompressingRecipe::duration, (StreamCodec)ItemStack.STREAM_CODEC, CompressingRecipe::result, CompressingRecipe::new);
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @NotNull
        public MapCodec<CompressingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CompressingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

