/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.datagen;

import com.portingdeadmods.power_armor.datagen.assets.EMBlockStateProvider;
import com.portingdeadmods.power_armor.datagen.assets.EMEnUsLangProvider;
import com.portingdeadmods.power_armor.datagen.assets.EMItemModelProvider;
import com.portingdeadmods.power_armor.datagen.data.EMBlockLootTableProvider;
import com.portingdeadmods.power_armor.datagen.data.EMRecipeProvider;
import com.portingdeadmods.power_armor.datagen.data.EMTagsProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="power_armor")
public final class EMDataGatherer {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new EMBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new EMItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new EMEnUsLangProvider(packOutput));
        EMTagsProvider.createTagProviders(generator, packOutput, lookupProvider, existingFileHelper, event.includeServer());
        generator.addProvider(event.includeServer(), (DataProvider)new EMRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(EMBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
    }
}

