/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.events;

import com.portingdeadmods.power_armor.api.AttackType;
import com.portingdeadmods.power_armor.client.InputHandler;
import com.portingdeadmods.power_armor.client.PAKeybinds;
import com.portingdeadmods.power_armor.client.sounds.JetpackSound;
import com.portingdeadmods.power_armor.networking.SetAttackTypePayload;
import com.portingdeadmods.power_armor.networking.UpdateInputPayload;
import com.portingdeadmods.power_armor.registries.PAArmorModules;
import com.portingdeadmods.power_armor.registries.PAAttachments;
import com.portingdeadmods.power_armor.utils.ArmorModuleUtils;
import com.portingdeadmods.power_armor.utils.VecHelper;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="power_armor", value={Dist.CLIENT})
public final class ClientEvents {
    public static int ATTACK_TYPES_AMOUNT = 1;
    private static boolean up = false;
    private static boolean down = false;
    private static boolean forwards = false;
    private static boolean backwards = false;
    private static boolean left = false;
    private static boolean right = false;
    private static boolean sprint = false;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        Options settings = mc.options;
        if (mc.getConnection() == null) {
            return;
        }
        boolean upNow = settings.keyJump.isDown();
        boolean downNow = settings.keyShift.isDown();
        boolean forwardsNow = settings.keyUp.isDown();
        boolean backwardsNow = settings.keyDown.isDown();
        boolean leftNow = settings.keyLeft.isDown();
        boolean rightNow = settings.keyRight.isDown();
        boolean sprintNow = settings.keySprint.isDown();
        if (upNow != up || downNow != down || forwardsNow != forwards || backwardsNow != backwards || leftNow != left || rightNow != right || sprintNow != sprint) {
            up = upNow;
            down = downNow;
            forwards = forwardsNow;
            backwards = backwardsNow;
            left = leftNow;
            right = rightNow;
            sprint = sprintNow;
            ClientEvents.update(up, down, forwards, backwards, left, right, sprint);
        }
        ClientEvents.renderParticles();
        if (((KeyMapping)PAKeybinds.CYCLE_ATTACK_TYPE_DOWN.get()).consumeClick()) {
            ClientEvents.cycleAttackType((Player)mc.player, -1);
        }
        if (((KeyMapping)PAKeybinds.CYCLE_ATTACK_TYPE_UP.get()).consumeClick()) {
            ClientEvents.cycleAttackType((Player)mc.player, 1);
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (((KeyMapping)PAKeybinds.LASER_ATTACK.get()).isDown()) {
            AttackType type = ArmorModuleUtils.getAttackType((Player)player);
            if (type.vanilla()) {
                return;
            }
            type.handle((Player)player, (Entity)player, player.swingingArm);
        }
    }

    private static void cycleAttackType(Player player, int change) {
        int index = (Integer)player.getData(PAAttachments.ATTACK_TYPE);
        int newIndex = index + change < 0 ? ATTACK_TYPES_AMOUNT - 1 : (index + change >= ATTACK_TYPES_AMOUNT ? 0 : index + change);
        player.setData(PAAttachments.ATTACK_TYPE, (Object)newIndex);
        PacketDistributor.sendToServer((CustomPacketPayload)new SetAttackTypePayload(newIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void update(boolean up, boolean down, boolean forwards, boolean backwards, boolean left, boolean right, boolean sprint) {
        LocalPlayer player = Minecraft.getInstance().player;
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateInputPayload(up, down, forwards, backwards, left, right, sprint), (CustomPacketPayload[])new CustomPacketPayload[0]);
        InputHandler.update((Player)player, up, down, forwards, backwards, left, right, sprint);
    }

    private static void renderParticles() {
        ItemStack chest;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.level != null && !mc.isPaused() && !(chest = mc.player.getItemBySlot(EquipmentSlot.CHEST)).isEmpty() && ArmorModuleUtils.hasModule(chest, PAArmorModules.JETPACK) && ClientEvents.isFlying((Player)mc.player)) {
            if (mc.options.particles().get() != ParticleStatus.MINIMAL) {
                double[] dArray;
                Vec3 playerPos = mc.player.position().add(0.0, 1.5, 0.0);
                float random = (ThreadLocalRandom.current().nextFloat() - 0.5f) * 0.1f;
                if (mc.player.isCrouching()) {
                    double[] dArray2 = new double[2];
                    dArray2[0] = -0.3;
                    dArray = dArray2;
                    dArray2[1] = -0.1;
                } else {
                    double[] dArray3 = new double[2];
                    dArray3[0] = 0.0;
                    dArray = dArray3;
                    dArray3[1] = 0.0;
                }
                double[] sneakBonus = dArray;
                Vec3 vLeft = VecHelper.rotate(new Vec3(-0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]), mc.player.yBodyRot, 0.0f, 0.0f);
                Vec3 vRight = VecHelper.rotate(new Vec3(0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]), mc.player.yBodyRot, 0.0f, 0.0f);
                double speedSide = 0.14;
                Vec3 v = playerPos.add(vLeft).add(mc.player.getDeltaMovement().scale(speedSide));
                mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, v.x, v.y, v.z, (double)random, -0.2, (double)random);
                mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.SMOKE, v.x, v.y, v.z, (double)random, -0.2, (double)random);
                v = playerPos.add(vRight).add(mc.player.getDeltaMovement().scale(speedSide));
                mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, v.x, v.y, v.z, (double)random, -0.2, (double)random);
                mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.SMOKE, v.x, v.y, v.z, (double)random, -0.2, (double)random);
            }
            if (!JetpackSound.isPlaying(mc.player.getId())) {
                mc.getSoundManager().play((SoundInstance)new JetpackSound((Player)mc.player));
            }
        }
    }

    public static boolean isFlying(Player player) {
        IEnergyStorage energy;
        if (player.isSpectator()) {
            return false;
        }
        ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!stack.isEmpty() && ((energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).getEnergyStored() > 0 || player.isCreative())) {
            return InputHandler.isHoldingUp(player);
        }
        return false;
    }
}

