/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.utils;

import com.portingdeadmods.power_armor.api.AttackType;
import com.portingdeadmods.power_armor.api.modules.ArmorModule;
import com.portingdeadmods.power_armor.api.modules.AttackArmorModule;
import com.portingdeadmods.power_armor.data.PAComponents;
import com.portingdeadmods.power_armor.data.components.ArmorModulesComponent;
import com.portingdeadmods.power_armor.registries.PAAttachments;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class ArmorModuleUtils {
    public static boolean hasModule(ItemStack stack, Supplier<? extends ArmorModule> module) {
        ArmorModulesComponent armorModulesComponent = (ArmorModulesComponent)stack.getOrDefault(PAComponents.ARMOR_MODULES, (Object)ArmorModulesComponent.EMPTY);
        return armorModulesComponent.modulesUnsafe().contains((Object)module.get());
    }

    public static boolean hasMultipleAttacks(Player player) {
        for (ItemStack stack : player.getArmorSlots()) {
            if (!stack.has(PAComponents.ARMOR_MODULES)) continue;
            NonNullList<ArmorModule> armorModules = ((ArmorModulesComponent)stack.get(PAComponents.ARMOR_MODULES)).modulesUnsafe();
            for (ArmorModule armorModule : armorModules) {
                if (!(armorModule instanceof AttackArmorModule)) continue;
                return true;
            }
        }
        return false;
    }

    public static Stream<ArmorModule> getModules(Player player) {
        return player.getInventory().armor.stream().filter(item -> item.has(PAComponents.ARMOR_MODULES)).flatMap(item -> ((ArmorModulesComponent)item.getOrDefault(PAComponents.ARMOR_MODULES, (Object)ArmorModulesComponent.EMPTY)).modulesUnsafe().stream());
    }

    public static <M> Stream<M> getModules(Player player, Class<M> clazz) {
        return ArmorModuleUtils.getModules(player).filter(clazz::isInstance).map(clazz::cast);
    }

    public static AttackType getAttackType(Player player) {
        int index = (Integer)player.getData(PAAttachments.ATTACK_TYPE);
        if (index == 0) {
            return AttackType.VANILLA;
        }
        List<AttackArmorModule> modules = ArmorModuleUtils.getModules(player, AttackArmorModule.class).toList();
        return modules.stream().map(AttackArmorModule::getAttackType).toList().get(index - 1);
    }
}

