/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.client;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

public final class InputHandler {
    private static final Map<Player, Boolean> HOLDING_UP = new WeakHashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_DOWN = new WeakHashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_FORWARDS = new WeakHashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_BACKWARDS = new WeakHashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_LEFT = new WeakHashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_RIGHT = new WeakHashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_SPRINT = new WeakHashMap<Player, Boolean>();

    public static boolean isHoldingUp(Player player) {
        return HOLDING_UP.containsKey(player) && HOLDING_UP.get(player) != false;
    }

    public static boolean isHoldingDown(Player player) {
        return HOLDING_DOWN.containsKey(player) && HOLDING_DOWN.get(player) != false;
    }

    public static boolean isHoldingForwards(Player player) {
        return HOLDING_FORWARDS.containsKey(player) && HOLDING_FORWARDS.get(player) != false;
    }

    public static boolean isHoldingBackwards(Player player) {
        return HOLDING_BACKWARDS.containsKey(player) && HOLDING_BACKWARDS.get(player) != false;
    }

    public static boolean isHoldingLeft(Player player) {
        return HOLDING_LEFT.containsKey(player) && HOLDING_LEFT.get(player) != false;
    }

    public static boolean isHoldingRight(Player player) {
        return HOLDING_RIGHT.containsKey(player) && HOLDING_RIGHT.get(player) != false;
    }

    public static boolean isHoldingSprint(Player player) {
        return HOLDING_SPRINT.containsKey(player) && HOLDING_SPRINT.get(player) != false;
    }

    public static void update(Player player, boolean up, boolean down, boolean forwards, boolean backwards, boolean left, boolean right, boolean sprint) {
        HOLDING_UP.put(player, up);
        HOLDING_DOWN.put(player, down);
        HOLDING_FORWARDS.put(player, forwards);
        HOLDING_BACKWARDS.put(player, backwards);
        HOLDING_LEFT.put(player, left);
        HOLDING_RIGHT.put(player, right);
        HOLDING_SPRINT.put(player, sprint);
    }

    public static void remove(Player player) {
        HOLDING_UP.remove(player);
        HOLDING_DOWN.remove(player);
        HOLDING_FORWARDS.remove(player);
        HOLDING_BACKWARDS.remove(player);
        HOLDING_LEFT.remove(player);
        HOLDING_RIGHT.remove(player);
        HOLDING_SPRINT.remove(player);
    }

    public static void clear() {
        HOLDING_UP.clear();
        HOLDING_DOWN.clear();
        HOLDING_FORWARDS.clear();
        HOLDING_BACKWARDS.clear();
        HOLDING_LEFT.clear();
        HOLDING_RIGHT.clear();
        HOLDING_SPRINT.clear();
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        InputHandler.remove(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        InputHandler.remove(event.getEntity());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        InputHandler.clear();
    }
}

