/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.client.screens;

import com.portingdeadmods.portingdeadlibs.api.client.screens.PanelContainerScreen;
import com.portingdeadmods.portingdeadlibs.api.client.screens.widgets.PanelWidget;
import com.portingdeadmods.portingdeadlibs.api.gui.menus.PDLAbstractContainerMenu;
import com.portingdeadmods.portingdeadlibs.client.screens.widgets.EnergyBarWidget;
import com.portingdeadmods.portingdeadlibs.client.screens.widgets.RedstonePanelWidget;
import com.portingdeadmods.power_armor.PowerArmor;
import com.portingdeadmods.power_armor.content.blockentities.CompressorBlockEntity;
import com.portingdeadmods.power_armor.content.menus.CompressorMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class CompressorScreen
extends PanelContainerScreen<CompressorMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = PowerArmor.rl("textures/gui/compressor.png");
    public static final ResourceLocation PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/furnace/burn_progress");

    public CompressorScreen(CompressorMenu menu, Inventory playerInventory, Component title) {
        super((PDLAbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.addRenderableOnly((Renderable)new EnergyBarWidget(this.leftPos + 11, this.topPos + 17, ((CompressorMenu)this.menu).blockEntity, true));
        this.addPanelWidget((PanelWidget)new RedstonePanelWidget(this.leftPos + this.imageWidth, this.topPos + 2));
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        CompressorBlockEntity be = (CompressorBlockEntity)((CompressorMenu)this.menu).getBlockEntity();
        if (be.getMaxProgress() != 0) {
            float progress = (float)be.getProgress() / (float)be.getMaxProgress();
            int width = (int)(24.0f * progress);
            pGuiGraphics.blitSprite(PROGRESS_SPRITE, 24, 16, 0, 0, this.leftPos + 79, this.topPos + 34, width, 16);
        }
    }

    @NotNull
    public ResourceLocation getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }
}

