/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.client.screens.widgets;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.capabilities.EnergyStorageWrapper;
import com.portingdeadmods.portingdeadlibs.api.capabilities.NeoEnergyStorageWrapper;
import com.portingdeadmods.power_armor.PowerArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PAEnergyBarWidget
extends AbstractWidget {
    private static final ResourceLocation ENERGY_BAR_BORDER = PowerArmor.rl("energy_bar_vertical_border");
    private static final ResourceLocation ENERGY_BAR_EMPTY_BORDER = PowerArmor.rl("energy_bar_vertical_empty_border");
    private final boolean hasBorder;
    private final EnergyStorageWrapper wrapper;
    private final String energyUnit;

    public PAEnergyBarWidget(int x, int y, EnergyStorageWrapper wrapper, String energyUnit, boolean hasBorder) {
        super(x, y, 12, 110, CommonComponents.EMPTY);
        this.hasBorder = hasBorder;
        this.wrapper = wrapper;
        this.energyUnit = energyUnit;
    }

    public PAEnergyBarWidget(int x, int y, ContainerBlockEntity blockEntity, boolean hasBorder) {
        this(x, y, (EnergyStorageWrapper)new NeoEnergyStorageWrapper(blockEntity.getEnergyStorage()), "FE", hasBorder);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.blitSprite(ENERGY_BAR_EMPTY_BORDER, this.width, this.height, 0, 0, this.getX(), this.getY(), this.width, this.height);
        int energyStored = this.wrapper.getEnergyStored();
        int maxStored = this.wrapper.getEnergyCapacity();
        int progress = (int)((float)this.height * ((float)energyStored / (float)maxStored));
        guiGraphics.blitSprite(ENERGY_BAR_BORDER, this.width, this.height, 0, this.height - progress, this.getX(), this.getY() + this.height - progress, this.width, progress);
        if (this.isHovered()) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)(this.wrapper.getEnergyStored() + "/" + this.wrapper.getEnergyCapacity() + this.energyUnit)), mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

