/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.content.blockentities;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.utils.capabilities.HandlerUtils;
import com.portingdeadmods.power_armor.PowerArmorConfig;
import com.portingdeadmods.power_armor.content.menus.ArmorModificationTableMenu;
import com.portingdeadmods.power_armor.data.ArmorModulesItemHandlerWrapper;
import com.portingdeadmods.power_armor.registries.PABlockEntityTypes;
import com.portingdeadmods.power_armor.registries.PATranslations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ArmorModificationTableBlockEntity
extends ContainerBlockEntity
implements MenuProvider {
    private final ArmorModulesItemHandlerWrapper itemHandler;

    public ArmorModificationTableBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(PABlockEntityTypes.ARMOR_MODIFICATION_TABLE.get(), blockPos, blockState);
        this.addEnergyStorage(HandlerUtils::newEnergystorage, builder -> builder.capacity(PowerArmorConfig.armorModificationTableEnergyCapacity).maxReceive(PowerArmorConfig.armorModificationTableEnergyTransfer).maxExtract(0).onChange(() -> ((ArmorModificationTableBlockEntity)this).updateData()));
        this.itemHandler = new ArmorModulesItemHandlerWrapper(ItemStack.EMPTY);
    }

    public void tick() {
        IEnergyStorage energyStorage = (IEnergyStorage)this.itemHandler.itemStack().getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage != null) {
            IEnergyStorage beEnergyStorage = this.getEnergyStorage();
            int extracted = beEnergyStorage.extractEnergy(PowerArmorConfig.powerArmorEnergyTransfer, false);
            energyStorage.receiveEnergy(extracted, false);
        }
    }

    public ArmorModulesItemHandlerWrapper getItemHandler() {
        return this.itemHandler;
    }

    public Component getDisplayName() {
        return PATranslations.ARMOR_MODIFICATION_SCREEN_TITLE.component(new Object[0]);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new ArmorModificationTableMenu(i, inventory, this);
    }

    public void dropItems(IItemHandler handler) {
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (NonNullList)NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{handler.getStackInSlot(0)}));
    }
}

