/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.content.items;

import com.portingdeadmods.power_armor.api.modules.ArmorModule;
import com.portingdeadmods.power_armor.registries.PAArmorModules;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ArmorModuleItem
extends Item {
    public ArmorModuleItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ArmorModule armorModule = ArmorModule.byItem(this);
        if (armorModule == PAArmorModules.LASER.get()) {
            tooltipComponents.add((Component)Component.literal((String)"WIP").withStyle(ChatFormatting.RED));
        }
        tooltipComponents.add((Component)Component.literal((String)"Can be applied to:").withStyle(ChatFormatting.GRAY));
        if (armorModule != null && armorModule.getArmorTypes() != null) {
            List<ArmorItem.Type> armorTypes = armorModule.getArmorTypes().stream().sorted(Comparator.comparingInt(Enum::ordinal)).toList();
            for (ArmorItem.Type armorType : armorTypes) {
                if (armorType == ArmorItem.Type.BODY) continue;
                String name = armorType.getSlot().getName();
                char[] charArray = name.toCharArray();
                charArray[0] = Character.toUpperCase(name.charAt(0));
                String newName = new String(charArray);
                tooltipComponents.add((Component)Component.literal((String)("- " + newName)).withStyle(ChatFormatting.GRAY));
            }
        }
    }
}

