/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.content.menus;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.gui.menus.PDLAbstractContainerMenu;
import com.portingdeadmods.power_armor.content.blockentities.ArmorModificationTableBlockEntity;
import com.portingdeadmods.power_armor.content.menus.ArmorSlot;
import com.portingdeadmods.power_armor.content.menus.SlotAccessor;
import com.portingdeadmods.power_armor.registries.PAMenuTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ArmorModificationTableMenu
extends PDLAbstractContainerMenu<ArmorModificationTableBlockEntity> {
    private final List<ArmorSlot> armorSlots = new ArrayList<ArmorSlot>();
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final Map<EquipmentSlot, ResourceLocation> TEXTURE_EMPTY_SLOTS = Map.of(EquipmentSlot.FEET, InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, EquipmentSlot.LEGS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, EquipmentSlot.CHEST, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, EquipmentSlot.HEAD, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET);

    public ArmorModificationTableMenu(int containerId, Inventory inv, FriendlyByteBuf byteBuf) {
        this(containerId, inv, (ArmorModificationTableBlockEntity)inv.player.level().getBlockEntity(byteBuf.readBlockPos()));
    }

    public ArmorModificationTableMenu(int containerId, @NotNull Inventory inv, @NotNull ArmorModificationTableBlockEntity blockEntity) {
        super(PAMenuTypes.ARMOR_MODIFICATION_TABLE.get(), containerId, inv, (ContainerBlockEntity)blockEntity);
        int x;
        int i;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getItemHandler(), 0, 90, 57));
        for (i = 0; i < 4; ++i) {
            x = 32 + (i == 0 || i == 3 ? 4 : 0);
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getItemHandler(), i + 1, x, 18 + i * 26));
        }
        for (i = 0; i < 4; ++i) {
            x = 148 - (i == 0 || i == 3 ? 4 : 0);
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getItemHandler(), i + 5, x, 18 + i * 26));
        }
        this.addPlayerInventory(inv, 10, 132);
        this.addPlayerHotbar(inv, 10, 190);
        NonNullList armor = inv.armor;
        int index = this.slots.stream().mapToInt(Slot::getSlotIndex).max().getAsInt();
        for (int i2 = 0; i2 < armor.size(); ++i2) {
            EquipmentSlot equipmentSlot = SLOT_IDS[i2];
            ResourceLocation resourcelocation = TEXTURE_EMPTY_SLOTS.get(equipmentSlot);
            ArmorSlot slot = new ArmorSlot((Container)inv, (LivingEntity)inv.player, equipmentSlot, 39 - i2, 189, 46 + i2 * 20, resourcelocation);
            slot.setActive(true);
            this.addSlot(slot);
            this.armorSlots.add(slot);
        }
    }

    protected void addPlayerInventory(Inventory playerInventory, int xOffset, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, xOffset + 8 + l * 18, y + i * 18));
            }
        }
    }

    protected void addPlayerHotbar(Inventory playerInventory, int xOffset, int y) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, xOffset + 8 + i * 18, y));
        }
    }

    public List<ArmorSlot> getArmorSlots() {
        return this.armorSlots;
    }

    protected int getMergeableSlotCount() {
        return 9;
    }

    public void setArmorSlotPositions(int startY) {
        List<ArmorSlot> upgradeSlots = this.getArmorSlots();
        for (int i = 0; i < upgradeSlots.size(); ++i) {
            ArmorSlot upgradeSlot = upgradeSlots.get(i);
            ((SlotAccessor)((Object)upgradeSlot)).powerArmor$setY(startY + i * 20);
        }
    }
}

