/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.content.modules;

import com.portingdeadmods.power_armor.PowerArmor;
import com.portingdeadmods.power_armor.PowerArmorConfig;
import com.portingdeadmods.power_armor.api.modules.ArmorModule;
import com.portingdeadmods.power_armor.data.PAComponents;
import com.portingdeadmods.power_armor.registries.PAItems;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;

public class PlatingArmorModule
implements ArmorModule {
    public static final Set<ArmorItem.Type> TYPES = Set.of(ArmorItem.Type.values());
    private static final Function<ItemStack, ItemAttributeModifiers> ATTRIBUTE_MODIFIERS = armorItem -> {
        ResourceLocation id = PowerArmor.rl("armor." + ((ArmorItem)armorItem.getItem()).getType().getName());
        return ItemAttributeModifiers.builder().add(Attributes.ARMOR, new AttributeModifier(id, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.ARMOR).add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.ARMOR).build();
    };

    @Override
    public Item getItem() {
        return (Item)PAItems.PLATING_ARMOR_MODULE.get();
    }

    @Override
    @Nullable
    public Set<ArmorItem.Type> getArmorTypes() {
        return TYPES;
    }

    @Override
    public int getEnergyUsage(ItemStack stack) {
        return PowerArmorConfig.powerArmorPlatingEnergyUsage;
    }

    @Override
    public void onAdded(ItemStack armorItem) {
        if (armorItem.has(PAComponents.DEFAULT_ATTRIBUTES)) {
            ItemAttributeModifiers attributeModifiers = (ItemAttributeModifiers)armorItem.get(PAComponents.DEFAULT_ATTRIBUTES);
            HashSet modifiers = new HashSet(attributeModifiers.modifiers());
            ItemAttributeModifiers modifiers1 = ATTRIBUTE_MODIFIERS.apply(armorItem);
            modifiers.addAll(modifiers1.modifiers());
            armorItem.set(PAComponents.DEFAULT_ATTRIBUTES, (Object)new ItemAttributeModifiers(List.copyOf(modifiers), attributeModifiers.showInTooltip()));
        }
    }

    @Override
    public void onRemoved(ItemStack armorItem) {
        ItemAttributeModifiers attributeModifiers = (ItemAttributeModifiers)armorItem.get(PAComponents.DEFAULT_ATTRIBUTES);
        ArrayList modifiers = new ArrayList(attributeModifiers.modifiers());
        ItemAttributeModifiers modifiers1 = ATTRIBUTE_MODIFIERS.apply(armorItem);
        modifiers.removeAll(modifiers1.modifiers());
        armorItem.set(PAComponents.DEFAULT_ATTRIBUTES, (Object)new ItemAttributeModifiers(modifiers, attributeModifiers.showInTooltip()));
    }

    @Override
    public void onPlayerAttacked(Player player, ItemStack armorItem) {
        this.extractEnergy(armorItem);
    }
}

