/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.data;

import com.portingdeadmods.power_armor.api.modules.ArmorModule;
import com.portingdeadmods.power_armor.data.PAComponents;
import com.portingdeadmods.power_armor.data.components.ArmorModulesComponent;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.UnknownNullability;

public class ArmorModulesItemHandlerWrapper
implements IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    private ItemStack itemStack;

    public ArmorModulesItemHandlerWrapper(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public int getSlots() {
        return this.getArmorModules().modulesAmount() + 1;
    }

    public ItemStack getStackInSlot(int i) {
        if (i == 0) {
            return this.itemStack.copy();
        }
        NonNullList<ArmorModule> modules = this.getArmorModules().modulesUnsafe();
        if (modules.size() > i - 1) {
            return ((ArmorModule)modules.get(i - 1)).getItem().getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack insertItem(int slot, ItemStack itemStack, boolean simulate) {
        if (slot == 0 && this.getStackInSlot(0).isEmpty()) {
            int count = itemStack.getCount();
            if (!simulate) {
                this.setStackInSlot(0, itemStack.copyWithCount(1));
            }
            return count - 1 <= 0 ? ItemStack.EMPTY : itemStack.copyWithCount(count - 1);
        }
        if (!simulate) {
            this.setStackInSlot(slot, itemStack);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int count, boolean simulate) {
        if (slot == 0) {
            ItemStack stack = this.itemStack.copy();
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.EMPTY);
            }
            return stack;
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (!simulate) {
            this.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return stack;
    }

    public int getSlotLimit(int i) {
        return 1;
    }

    public boolean isItemValid(int i, ItemStack itemStack) {
        ArmorItem.Type armorType;
        if (i == 0) {
            return itemStack.has(PAComponents.ARMOR_MODULES);
        }
        if (!this.itemStack.has(PAComponents.ARMOR_MODULES)) {
            return false;
        }
        Item item = this.itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            armorType = armorItem.getType();
        } else {
            armorType = null;
        }
        ArmorModule armorModule = ArmorModule.byItem(itemStack.getItem());
        return armorModule != null && !this.getArmorModules().modulesUnsafe().contains((Object)armorModule) && (armorType == null || armorModule.getArmorTypes() == null || armorModule.getArmorTypes().contains(armorType));
    }

    public void setStackInSlot(int i, ItemStack itemStack) {
        if (i == 0) {
            this.itemStack = itemStack.copy();
            return;
        }
        if (!itemStack.isEmpty() && !this.itemStack.has(PAComponents.ARMOR_MODULES)) {
            return;
        }
        ArmorModule armorModule = ArmorModule.byItem(itemStack.getItem());
        NonNullList<ArmorModule> modules = this.getArmorModules().modules();
        if (modules.size() > i - 1) {
            if (armorModule != null && armorModule != ArmorModule.EMPTY) {
                modules.set(i - 1, (Object)armorModule);
                armorModule.onAdded(this.itemStack);
            } else if (itemStack.isEmpty()) {
                ArmorModule prevModule = (ArmorModule)modules.get(i - 1);
                modules.set(i - 1, (Object)ArmorModule.EMPTY);
                prevModule.onRemoved(this.itemStack);
            }
        }
        this.itemStack.set(PAComponents.ARMOR_MODULES.get(), (Object)new ArmorModulesComponent(modules, this.getArmorModules().modulesAmount()));
    }

    private ArmorModulesComponent getArmorModules() {
        return (ArmorModulesComponent)this.itemStack.getOrDefault(PAComponents.ARMOR_MODULES, (Object)ArmorModulesComponent.EMPTY);
    }

    public ItemStack itemStack() {
        return this.itemStack;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ArmorModulesItemHandlerWrapper that = (ArmorModulesItemHandlerWrapper)obj;
        return Objects.equals(this.itemStack, that.itemStack);
    }

    public int hashCode() {
        return Objects.hash(this.itemStack);
    }

    public String toString() {
        return "ArmorModulesItemHandlerWrapper[itemStack=" + String.valueOf(this.itemStack) + "]";
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return new CompoundTag();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
    }
}

