/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.datagen.assets;

import com.portingdeadmods.portingdeadlibs.api.datagen.ModelBuilder;
import com.portingdeadmods.power_armor.PowerArmor;
import com.portingdeadmods.power_armor.registries.PABlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

public class EMBlockStateProvider
extends BlockStateProvider {
    public EMBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "power_armor", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)PABlocks.MACHINE_FRAME.get());
        this.simpleBlock((Block)PABlocks.ARMOR_MODIFICATION_TABLE.get(), (ModelFile)this.models().getExistingFile(PowerArmor.rl("block/armor_modification_table")));
        this.modelBuilder((Block)PABlocks.COMPRESSOR.get()).front(this::blockTexture, "_front").horizontalFacing().active().create();
    }

    @NotNull
    private ModelBuilder modelBuilder(Block block) {
        return new ModelBuilder(block, (BlockStateProvider)this).defaultTexture(this.blockTexture((Block)PABlocks.MACHINE_FRAME.get()));
    }

    private ResourceLocation machineTexture(DeferredBlock<?> block, String suffix) {
        return this.blockTexture((Block)block.get(), "machine", suffix);
    }

    private ResourceLocation machineTexture(DeferredBlock<?> block) {
        return this.blockTexture((Block)block.get(), "machine", "");
    }

    private ResourceLocation machineTexture(Block block, String suffix) {
        return this.blockTexture(block, "machine", suffix);
    }

    private ResourceLocation machineTexture(Block block) {
        return this.blockTexture(block, "machine", "");
    }

    public ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private ResourceLocation blockTexture(Block block, String textureFolder, String suffix) {
        ResourceLocation name = this.key(block);
        if (textureFolder == null || textureFolder.trim().isEmpty()) {
            return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath() + suffix));
        }
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + textureFolder + "/" + name.getPath() + suffix));
    }

    private ResourceLocation blockTexture(Block block, String suffix) {
        return this.blockTexture(block, "", suffix);
    }
}

