/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.power_armor.datagen.assets;

import com.portingdeadmods.power_armor.client.items.PAItemProperties;
import com.portingdeadmods.power_armor.registries.PABlocks;
import com.portingdeadmods.power_armor.registries.PAItems;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class EMItemModelProvider
extends ItemModelProvider {
    public EMItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "power_armor", existingFileHelper);
    }

    protected void registerModels() {
        PABlocks.BLOCKS.getBlockItems().stream().map(Supplier::get).map(BlockItem::getBlock).forEach(arg_0 -> ((EMItemModelProvider)this).simpleBlockItem(arg_0));
        this.basicItem((Item)PAItems.COPPER_PLATE.get());
        this.basicItem((Item)PAItems.IRON_PLATE.get());
        this.basicItem((Item)PAItems.COPPER_WIRE.get());
        this.basicItem((Item)PAItems.ARMOR_PLATING.get());
        this.basicItem((Item)PAItems.BLANK_ARMOR_MODULE.get());
        this.basicItem((Item)PAItems.JETPACK_ARMOR_MODULE.get());
        this.basicItem((Item)PAItems.LASER_ARMOR_MODULE.get());
        this.basicItem((Item)PAItems.SOLAR_ARMOR_MODULE.get());
        this.basicItem((Item)PAItems.PLATING_ARMOR_MODULE.get());
        this.basicItem((Item)PAItems.NIGHT_VISION_ARMOR_MODULE.get());
        this.basicItem((Item)PAItems.ENERGY_ARMOR_MODULE.get());
        this.basicItem((Item)PAItems.SPEED_ARMOR_MODULE.get());
        this.overrideItemModel(6, this.basicItem((ItemLike)PAItems.BATTERY.get(), this.extend(this.itemTexture((ItemLike)PAItems.BATTERY.get()), "_0")), PAItemProperties.BATTERY_STAGE, i -> this.basicItem((ItemLike)PAItems.BATTERY.get(), "_" + i));
        this.basicItem((Item)PAItems.POWER_ARMOR_HELMET.get());
        this.basicItem((Item)PAItems.POWER_ARMOR_CHESTPLATE.get());
        this.basicItem((Item)PAItems.POWER_ARMOR_LEGGINGS.get());
        this.basicItem((Item)PAItems.POWER_ARMOR_BOOTS.get());
    }

    private void overrideItemModel(int variants, ItemModelBuilder defaultModel, ResourceLocation key, Function<Integer, ItemModelBuilder> overrideFunction) {
        for (int i = 0; i < variants; ++i) {
            ItemModelBuilder model = overrideFunction.apply(i);
            defaultModel.override().model((ModelFile)model).predicate(key, (float)i).end();
        }
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath() + suffix));
    }

    @NotNull
    private static ResourceLocation key(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem());
    }

    public ResourceLocation itemTexture(ItemLike item) {
        ResourceLocation name = EMItemModelProvider.key(item);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("item/" + name.getPath()));
    }

    public ItemModelBuilder basicItem(ItemLike itemLike) {
        return this.basicItem(itemLike, "");
    }

    public ItemModelBuilder basicItem(ItemLike item, String suffix) {
        ResourceLocation location = EMItemModelProvider.key(item);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(String.valueOf(location) + suffix)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("item/" + location.getPath() + suffix)));
    }

    public String name(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }

    public ItemModelBuilder basicItem(ItemLike item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)texture.getPath()));
    }
}

